/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata;
import it.geosolutions.imageio.plugins.arcgrid.raster.AsciiGridRaster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.iterator.RectIter;
import org.eclipse.imagen.iterator.RectIterFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class AsciiGridsImageWriter
extends ImageWriter {
    private static final Logger LOGGER = Logger.getLogger(AsciiGridsImageWriter.class.toString());
    private boolean hasListeners;
    public static final double EPS = 0.001;
    private AsciiGridsImageMetadata imageMetadata = null;
    private ImageOutputStream imageOutputStream;
    private AsciiGridRaster rasterWriter = null;
    private PlanarImage inputRenderedImage;
    private AsciiGridRaster.AsciiGridRasterType rasterType;
    private int nColumns;
    private int nRows;
    private double cellsizeX;
    private double cellsizeY;
    private AsciiGridsImageMetadata.RasterSpaceType rasterSpaceType;
    private String noDataValueString;
    private double xll;
    private double yll;

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new AsciiGridsImageWriteParam(this.getLocale());
    }

    public AsciiGridsImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("Not a valid type of Output ");
            }
            this.imageOutputStream = (ImageOutputStreamImpl)output;
        } else {
            this.imageOutputStream = null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("Setting Output");
        }
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        boolean bl = this.hasListeners = this.progressListeners != null && !this.progressListeners.isEmpty();
        if (this.hasListeners) {
            this.clearAbortRequest();
            this.processImageStarted(0);
        }
        this.inputRenderedImage = PlanarImage.wrapRenderedImage((RenderedImage)image.getRenderedImage());
        this.imageMetadata = (AsciiGridsImageMetadata)image.getMetadata();
        Node root = this.imageMetadata.getAsTree("it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata_1.0");
        this.retrieveMetadata(root);
        this.writeHeader();
        this.writeRaster();
        this.imageOutputStream.flush();
        if (this.hasListeners) {
            if (this.rasterWriter.isAborting()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
            }
        }
    }

    private void retrieveMetadata(Node root) throws IOException {
        Node formatDescriptorNode = root.getFirstChild();
        this.rasterType = Boolean.valueOf(formatDescriptorNode.getAttributes().getNamedItem("GRASS").getNodeValue()) != false ? AsciiGridRaster.AsciiGridRasterType.GRASS : AsciiGridRaster.AsciiGridRasterType.ESRI;
        Node gridDescriptorNode = formatDescriptorNode.getNextSibling();
        NamedNodeMap attributes = gridDescriptorNode.getAttributes();
        this.nColumns = Integer.parseInt(attributes.getNamedItem("nColumns").getNodeValue());
        this.nRows = Integer.parseInt(attributes.getNamedItem("nRows").getNodeValue());
        this.rasterSpaceType = AsciiGridsImageMetadata.RasterSpaceType.valueOf(attributes.getNamedItem("rasterSpaceType").getNodeValue());
        this.noDataValueString = null;
        Node dummyNode = attributes.getNamedItem("noDataValue");
        if (dummyNode != null) {
            this.noDataValueString = dummyNode.getNodeValue();
        }
        Node envelopDescriptorNode = gridDescriptorNode.getNextSibling();
        this.cellsizeX = Double.parseDouble(envelopDescriptorNode.getAttributes().getNamedItem("cellsizeX").getNodeValue());
        this.cellsizeY = Double.parseDouble(envelopDescriptorNode.getAttributes().getNamedItem("cellsizeY").getNodeValue());
        this.xll = Double.parseDouble(envelopDescriptorNode.getAttributes().getNamedItem("xll").getNodeValue());
        this.yll = Double.parseDouble(envelopDescriptorNode.getAttributes().getNamedItem("yll").getNodeValue());
        int actualWidth = this.inputRenderedImage.getWidth();
        int actualHeight = this.inputRenderedImage.getHeight();
        this.cellsizeX *= (double)(this.nColumns / actualWidth);
        this.cellsizeY *= (double)(this.nRows / actualHeight);
        if (this.rasterType.equals((Object)AsciiGridRaster.AsciiGridRasterType.GRASS) && AsciiGridsImageWriter.resolutionCheck(this.cellsizeX, this.cellsizeX, 0.001)) {
            throw new IOException("The provided metadata are illegal!CellSizeX!=CellSizeY.");
        }
    }

    public static boolean resolutionCheck(double cellsizeX, double cellsizeY, double eps) {
        return Math.abs(cellsizeX - cellsizeY) / Math.min(cellsizeX, cellsizeY) > eps;
    }

    private void writeRaster() throws IOException {
        RectIter iterator = RectIterFactory.create((RenderedImage)this.inputRenderedImage, null);
        Double noDataDouble = new Double(this.rasterWriter.getNoData());
        String noDataMarker = this.rasterWriter.getNoDataMarker();
        this.rasterWriter.writeRaster(iterator, noDataDouble, noDataMarker);
    }

    private void writeHeader() throws IOException {
        this.rasterWriter = this.rasterType.createAsciiGridRaster(this.imageOutputStream, this);
        this.rasterWriter.writeHeader(Integer.toString(this.nColumns), Integer.toString(this.nRows), Double.toString(this.xll), Double.toString(this.yll), Double.toString(this.cellsizeX), Double.toString(this.cellsizeY), this.rasterSpaceType.toString(), this.noDataValueString);
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier its, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata md, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata md, ImageTypeSpecifier its, ImageWriteParam param) {
        return md;
    }

    @Override
    public void dispose() {
        if (this.imageOutputStream != null) {
            try {
                this.imageOutputStream.flush();
                this.imageOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.imageOutputStream = null;
        super.dispose();
    }

    @Override
    public synchronized void abort() {
        if (this.rasterWriter != null) {
            this.rasterWriter.abort();
        }
    }

    @Override
    protected synchronized boolean abortRequested() {
        return this.rasterWriter.isAborting();
    }

    @Override
    protected synchronized void clearAbortRequest() {
        if (this.rasterWriter != null) {
            this.rasterWriter.clearAbort();
        }
    }

    @Override
    public void processImageProgress(float percentageDone) {
        super.processImageProgress(percentageDone);
    }

    public int getNColumns() {
        return this.nColumns;
    }

    public int getNRows() {
        return this.nRows;
    }

    public boolean isHasListeners() {
        return this.hasListeners;
    }

    @Override
    public void reset() {
        super.reset();
        this.imageOutputStream = null;
        this.imageMetadata = null;
        this.rasterWriter = null;
        this.inputRenderedImage = null;
    }

    final class AsciiGridsImageWriteParam
    extends ImageWriteParam {
        AsciiGridsImageWriteParam(Locale locale) {
            super(locale);
            this.compressionMode = 0;
            this.canWriteCompressed = true;
        }

        @Override
        public void setCompressionMode(int mode) {
            if (mode == 2 || mode == 3) {
                throw new UnsupportedOperationException("mode == MODE_EXPLICIT || mode == MODE_COPY_FROM_METADATA");
            }
            super.setCompressionMode(mode);
        }

        @Override
        public void unsetCompression() {
            super.unsetCompression();
        }
    }
}

