/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Context;
import com.azure.core.util.HttpClientOptions;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobDownloadContentResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.DownloadRetryOptions;
import it.geosolutions.imageioimpl.plugins.cog.AzureConfigurationProperties;
import java.time.Duration;

class AzureClient {
    private static final int HTTP_CODE_NOT_FOUND = 404;
    public static final String AZURE_URL_BASE = "blob.core.windows.net";
    private AzureConfigurationProperties configuration;
    private final BlobContainerClient container;

    public AzureClient(AzureConfigurationProperties configuration) {
        this.configuration = configuration;
        BlobServiceClient serviceClient = this.createBlobServiceClient();
        String containerName = configuration.getContainer();
        this.container = this.getContainer(serviceClient, containerName);
    }

    BlobContainerClient getContainer(BlobServiceClient serviceClient, String containerName) {
        BlobContainerClient containerClient;
        try {
            containerClient = serviceClient.getBlobContainerClient(containerName);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Failed to setup Azure connection and container", e);
        }
        if (!containerClient.exists()) {
            throw new IllegalArgumentException("container " + containerName + " does not exist");
        }
        return containerClient;
    }

    BlobServiceClient createBlobServiceClient() {
        String serviceURL = this.getServiceURL(this.configuration);
        AzureNamedKeyCredential creds = this.getCredentials(this.configuration);
        ClientOptions clientOpts = new ClientOptions();
        HttpClient httpClient = this.createHttpClient(this.configuration);
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().endpoint(serviceURL).clientOptions(clientOpts).httpClient(httpClient);
        if (null != creds) {
            builder = builder.credential(creds);
        }
        return builder.buildClient();
    }

    AzureNamedKeyCredential getCredentials(AzureConfigurationProperties configuration) {
        String accountName = configuration.getAccountName();
        String accountKey = configuration.getAccountKey();
        if (null != accountName && null != accountKey) {
            return new AzureNamedKeyCredential(accountName, accountKey);
        }
        return null;
    }

    HttpClient createHttpClient(AzureConfigurationProperties blobStoreConfig) {
        Integer maxConnections = blobStoreConfig.getMaxConnections();
        HttpClientOptions opts = new HttpClientOptions();
        opts.setMaximumConnectionPoolSize(maxConnections);
        return HttpClient.createDefault((HttpClientOptions)opts);
    }

    String getServiceURL(AzureConfigurationProperties configuration) {
        String serviceURL = configuration.getServiceURL();
        if (serviceURL == null) {
            String proto = configuration.isUseHTTPS() ? "https" : "http";
            String account = configuration.getAccountName();
            serviceURL = String.format("%s://%s.blob.core.windows.net", proto, account);
        }
        return serviceURL;
    }

    private BlobDownloadContentResponse download(String key, BlobRange range) {
        BlobClient blobClient = this.container.getBlobClient(key);
        DownloadRetryOptions options = new DownloadRetryOptions().setMaxRetryRequests(0);
        BlobRequestConditions conditions = null;
        Duration timeout = null;
        Context context = Context.NONE;
        try {
            return blobClient.downloadContentWithResponse(options, conditions, range, false, timeout, context);
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public byte[] getBytes(String key, BlobRange range) {
        BlobDownloadContentResponse download = this.download(key, range);
        return download == null ? null : ((BinaryData)download.getValue()).toBytes();
    }
}

