/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobRange;
import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.AbstractRangeReader;
import it.geosolutions.imageioimpl.plugins.cog.AzureClient;
import it.geosolutions.imageioimpl.plugins.cog.AzureClientFactory;
import it.geosolutions.imageioimpl.plugins.cog.AzureConfigurationProperties;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class AzureRangeReader
extends AbstractRangeReader {
    protected AzureClient client;
    protected AzureConfigurationProperties configProps;
    private String blobKey;
    private static final int CORE_POOL_SIZE = Integer.getInteger("azure.reader.core.poolsize", 64);
    private static final int MAX_POOL_SIZE = Integer.getInteger("azure.reader.max.poolsize", 128);
    private static final int THREAD_TIMEOUT = Integer.getInteger("azure.reader.timeout.ms", 10000);
    static final ThreadPoolExecutor EXECUTORS = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, THREAD_TIMEOUT, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private static final Logger LOGGER = Logger.getLogger(AzureRangeReader.class.getName());

    public AzureRangeReader(String url, int headerLength) {
        this(URI.create(url), headerLength);
    }

    public AzureRangeReader(URL url, int headerLength) {
        this(URI.create(url.toString()), headerLength);
    }

    public AzureRangeReader(URI uri, int headerLength) {
        this(new BasicAuthURI(uri), headerLength);
    }

    public AzureRangeReader(BasicAuthURI uri, int headerLength) {
        super(uri, headerLength);
        this.configProps = new AzureConfigurationProperties(uri);
        this.client = AzureClientFactory.getClient(this.configProps);
        this.blobKey = this.getBlobKey(uri.getUri());
    }

    public String getBlobKey(URI uri) {
        String path = uri.toASCIIString();
        try {
            BlobUrlParts parts = BlobUrlParts.parse((URL)uri.toURL());
            return parts.getBlobName();
        }
        catch (IllegalStateException | MalformedURLException e) {
            throw new RuntimeException("Unable to parse the provided uri " + path + "due to " + e.getLocalizedMessage());
        }
    }

    public byte[] fetchHeader() {
        byte[] currentHeader = (byte[])this.data.get((Object)0L);
        if (currentHeader != null) {
            this.headerOffset = currentHeader.length;
        }
        BlobRange range = this.buildRange(this.headerOffset, this.headerLength);
        try {
            byte[] headerBytes = this.client.getBytes(this.blobKey, range);
            if (this.headerOffset != 0) {
                byte[] oldHeader = (byte[])this.data.get((Object)0L);
                byte[] newHeader = new byte[headerBytes.length + oldHeader.length];
                System.arraycopy(oldHeader, 0, newHeader, 0, oldHeader.length);
                System.arraycopy(headerBytes, 0, newHeader, oldHeader.length, headerBytes.length);
                headerBytes = newHeader;
            }
            this.data.put((Object)0L, (Object)headerBytes);
            return headerBytes;
        }
        catch (Exception e) {
            LOGGER.severe("Error reading header for " + this.uri);
            throw new RuntimeException(e);
        }
    }

    private BlobRange buildRange(long rangeStart, long rangeLength) {
        return new BlobRange(rangeStart, Long.valueOf(rangeLength));
    }

    public Map<Long, byte[]> read(Collection<long[]> ranges) {
        return this.read((long[][])ranges.toArray((T[])new long[0][]));
    }

    public byte[] readHeader() {
        LOGGER.fine("reading header");
        byte[] currentHeader = (byte[])HEADERS_CACHE.get(this.uri.toString());
        if (currentHeader != null) {
            return currentHeader;
        }
        BlobRange range = this.buildRange(this.headerOffset, this.headerLength);
        try {
            byte[] headerBytes = this.client.getBytes(this.blobKey, range);
            this.data.put((Object)0L, (Object)headerBytes);
            HEADERS_CACHE.put(this.uri.toString(), headerBytes);
            return headerBytes;
        }
        catch (Exception e) {
            LOGGER.severe("Error reading header for " + this.uri);
            throw new RuntimeException(e);
        }
    }

    public Map<Long, byte[]> read(long[] ... ranges) {
        ranges = this.reconcileRanges(ranges);
        ConcurrentHashMap<Long, byte[]> values = new ConcurrentHashMap<Long, byte[]>();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < ranges.length; ++i) {
            long[] lArray = ranges[i];
            long rangeStart = lArray[0];
            byte[] dataRange = (byte[])this.data.get((Object)rangeStart);
            if (dataRange == null) {
                Future<?> future = EXECUTORS.submit(() -> {
                    long rangeEnd = range[1];
                    int length = (int)(rangeEnd - rangeStart) + 1;
                    byte[] bytes = this.readInternal(rangeStart, length);
                    this.data.put((Object)rangeStart, (Object)bytes);
                    values.put(rangeStart, bytes);
                });
                futures.add(future);
                continue;
            }
            values.put(rangeStart, dataRange);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read data from Azure Blob Storage", e);
            }
        }
        return values;
    }

    byte[] readInternal(long readOffset, int readLength) {
        BlobRange range = this.buildRange(readOffset, readLength);
        return this.client.getBytes(this.blobKey, range);
    }
}

