/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import com.azure.storage.blob.BlobUrlParts;
import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.PropertyLocator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class AzureConfigurationProperties {
    private static final String AZURE_ACCOUNT_NAME = "azure.reader.accountName";
    private static final String AZURE_ACCOUNT_KEY = "azure.reader.accountKey";
    private static final String AZURE_ACCOUNT_CONTAINER = "azure.reader.container";
    private static final String AZURE_ACCOUNT_PREFIX = "azure.reader.prefix";
    private static final String AZURE_MAX_CONNECTIONS = "azure.reader.maxConnections";
    private String container;
    private String prefix;
    private String accountName;
    private String accountKey;
    private Integer maxConnections = 64;
    private boolean useHTTPS = true;
    private String serviceURL = null;

    AzureConfigurationProperties(BasicAuthURI cogUri) {
        URI uri = cogUri.getUri();
        String path = uri.toASCIIString();
        if (path.startsWith("https")) {
            path = path.replaceFirst("https", "http");
            this.useHTTPS = true;
        }
        try {
            String host;
            int blobcoreIdx;
            BlobUrlParts parts = BlobUrlParts.parse((URL)uri.toURL());
            this.container = parts.getBlobContainerName();
            String blobName = parts.getBlobName();
            int lastIndex = blobName.lastIndexOf("/");
            if (lastIndex > 0) {
                this.prefix = blobName.substring(0, lastIndex);
            }
            if ((blobcoreIdx = (host = parts.getHost()).indexOf(".blob.core.windows.net")) > 0) {
                this.accountName = host.substring(0, blobcoreIdx);
            }
        }
        catch (IllegalStateException | MalformedURLException e) {
            throw new RuntimeException("Unable to parse the provided uri " + path + "due to " + e.getLocalizedMessage());
        }
        if (this.container == null) {
            this.container = PropertyLocator.getEnvironmentValue((String)AZURE_ACCOUNT_CONTAINER, null);
        }
        if (this.prefix == null) {
            this.prefix = PropertyLocator.getEnvironmentValue((String)AZURE_ACCOUNT_PREFIX, null);
        }
        if (cogUri.getUser() != null && cogUri.getPassword() != null) {
            this.accountName = cogUri.getUser();
            this.accountKey = cogUri.getPassword();
        }
        if (this.accountName == null) {
            this.accountName = PropertyLocator.getEnvironmentValue((String)AZURE_ACCOUNT_NAME, null);
        }
        if (this.accountKey == null) {
            this.accountKey = PropertyLocator.getEnvironmentValue((String)AZURE_ACCOUNT_KEY, null);
        }
        if (this.maxConnections == null) {
            this.maxConnections = Integer.parseInt(PropertyLocator.getEnvironmentValue((String)AZURE_MAX_CONNECTIONS, (String)"5"));
        }
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    public void setUseHTTPS(boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }
}

