/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.geosolutions.imageio.core.ExtCaches;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

class BlobCache {
    private static final Logger LOGGER = Logger.getLogger(BlobCache.class.getName());
    static final LoadingCache<BlobKey, Optional<Blob>> BLOB_CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<BlobKey, Optional<Blob>>(){

        public Optional<Blob> load(BlobKey key) {
            return Optional.ofNullable(key.storage.get(key.blobId));
        }
    });
    static final LoadingCache<String, Storage> STORAGE_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Storage>(){

        public Storage load(String key) {
            Storage storage;
            block9: {
                InputStream is = new URL(key).openStream();
                try {
                    GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)is);
                    Storage storage2 = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).build().getService();
                    if (storage2 == null) {
                        LOGGER.log(Level.SEVERE, "Failed to connect to Google Storage using  explicitly provided credentials : " + key);
                        throw new RuntimeException("Failed to create a Google Storage connection with the provided credentials");
                    }
                    storage = storage2;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create a Google Storage connection", e);
                    }
                }
                is.close();
            }
            return storage;
        }
    });
    static final Storage DEFAULT_STORAGE = (Storage)StorageOptions.getDefaultInstance().getService();

    BlobCache() {
    }

    static Blob getBlob(String auth, BlobId blobId) {
        try {
            Storage storage = auth != null ? (Storage)STORAGE_CACHE.get((Object)auth) : DEFAULT_STORAGE;
            return ((Optional)BLOB_CACHE.get((Object)new BlobKey(storage, blobId))).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to look up blob in cache: " + blobId, e);
        }
    }

    static {
        ExtCaches.addListener(() -> {
            STORAGE_CACHE.invalidateAll();
            BLOB_CACHE.invalidateAll();
        });
    }

    private static class BlobKey {
        Storage storage;
        BlobId blobId;

        public BlobKey(Storage storage, BlobId blobId) {
            this.storage = storage;
            this.blobId = blobId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlobKey cacheKey = (BlobKey)o;
            return Objects.equals(this.storage, cacheKey.storage) && Objects.equals(this.blobId, cacheKey.blobId);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.blobId);
        }
    }
}

