/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class AsyncHttpCallback
implements Callback {
    private Status status = Status.IN_PROGRESS;
    private long startPosition;
    private long endPosition;
    private byte[] bytes;
    private static final Logger LOGGER = Logger.getLogger(AsyncHttpCallback.class.getName());

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        LOGGER.severe("Error executing HTTP request. " + e);
        this.status = Status.FAILED;
    }

    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try {
            this.bytes = response.body().bytes();
            this.status = Status.DONE;
        }
        catch (IOException ioe) {
            this.status = Status.FAILED;
            throw ioe;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void resetStatus() {
        this.status = Status.IN_PROGRESS;
    }

    public AsyncHttpCallback initRange(long[] range) {
        this.startPosition = range[0];
        this.endPosition = range[1];
        return this;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.endPosition;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    static enum Status {
        DONE,
        FAILED,
        IN_PROGRESS;

    }
}

