/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.AbstractRangeReader;
import it.geosolutions.imageioimpl.plugins.cog.S3ClientFactory;
import it.geosolutions.imageioimpl.plugins.cog.S3ConfigurationProperties;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class S3RangeReader
extends AbstractRangeReader {
    protected S3AsyncClient client;
    protected S3ConfigurationProperties configProps;
    private static final Logger LOGGER = Logger.getLogger(S3RangeReader.class.getName());

    public S3RangeReader(String url, int headerLength) {
        this(URI.create(url), headerLength);
    }

    public S3RangeReader(URL url, int headerLength) {
        this(URI.create(url.toString()), headerLength);
    }

    public S3RangeReader(URI uri, int headerLength) {
        this(new BasicAuthURI(uri), headerLength);
    }

    public S3RangeReader(BasicAuthURI uri, int headerLength) {
        super(uri, headerLength);
        this.configProps = new S3ConfigurationProperties(uri.getUri().getScheme(), uri);
        this.client = S3ClientFactory.getS3Client(this.configProps);
    }

    public byte[] fetchHeader() {
        byte[] currentHeader = (byte[])this.data.get((Object)0L);
        if (currentHeader != null) {
            this.headerOffset = currentHeader.length;
        }
        GetObjectRequest headerRequest = this.buildRequest();
        try {
            ResponseBytes responseBytes = (ResponseBytes)this.client.getObject(headerRequest, AsyncResponseTransformer.toBytes()).get();
            byte[] headerBytes = responseBytes.asByteArray();
            if (this.headerOffset != 0) {
                byte[] oldHeader = (byte[])this.data.get((Object)0L);
                byte[] newHeader = new byte[headerBytes.length + oldHeader.length];
                System.arraycopy(oldHeader, 0, newHeader, 0, oldHeader.length);
                System.arraycopy(headerBytes, 0, newHeader, oldHeader.length, headerBytes.length);
                headerBytes = newHeader;
            }
            this.data.put((Object)0L, (Object)headerBytes);
            return headerBytes;
        }
        catch (Exception e) {
            LOGGER.severe("Error reading header for " + this.uri);
            throw new RuntimeException(e);
        }
    }

    public Map<Long, byte[]> read(Collection<long[]> ranges) {
        return this.read((long[][])ranges.toArray((T[])new long[0][]));
    }

    public byte[] readHeader() {
        LOGGER.fine("reading header");
        byte[] currentHeader = (byte[])HEADERS_CACHE.get(this.uri.toString());
        if (currentHeader != null) {
            return currentHeader;
        }
        GetObjectRequest headerRequest = this.buildRequest();
        try {
            ResponseBytes responseBytes = (ResponseBytes)this.client.getObject(headerRequest, AsyncResponseTransformer.toBytes()).get();
            byte[] headerBytes = responseBytes.asByteArray();
            this.data.put((Object)0L, (Object)headerBytes);
            HEADERS_CACHE.put(this.uri.toString(), headerBytes);
            return headerBytes;
        }
        catch (Exception e) {
            LOGGER.severe("Error reading header for " + this.uri);
            throw new RuntimeException(e);
        }
    }

    private GetObjectRequest buildRequest() {
        return (GetObjectRequest)GetObjectRequest.builder().bucket(this.configProps.getBucket()).key(this.configProps.getKey()).range("bytes=" + this.headerOffset + "-" + (this.headerOffset + this.headerLength - 1)).build();
    }

    public Map<Long, byte[]> read(long[] ... ranges) {
        ranges = this.reconcileRanges(ranges);
        Instant start = Instant.now();
        HashMap<Long, CompletableFuture<ResponseBytes<GetObjectResponse>>> downloads = new HashMap<Long, CompletableFuture<ResponseBytes<GetObjectResponse>>>(ranges.length);
        HashMap<Long, byte[]> values = new HashMap<Long, byte[]>();
        int[] missingRanges = new int[ranges.length];
        int missing = 0;
        for (int i = 0; i < ranges.length; ++i) {
            long[] range = ranges[i];
            long rangeStart = range[0];
            byte[] dataRange = (byte[])this.data.get((Object)rangeStart);
            if (dataRange == null) {
                long rangeEnd = range[1];
                CompletableFuture<ResponseBytes<GetObjectResponse>> futureGet = this.readAsync(rangeStart, rangeEnd);
                downloads.put(rangeStart, futureGet);
                missingRanges[missing++] = i;
                continue;
            }
            values.put(rangeStart, dataRange);
        }
        this.awaitCompletion(values, downloads);
        Instant end = Instant.now();
        LOGGER.fine("Time to read all ranges: " + Duration.between(start, end));
        for (int k = 0; k < missing; ++k) {
            long range = ranges[missingRanges[k]][0];
            this.data.put((Object)range, (Object)((byte[])values.get(range)));
        }
        return values;
    }

    CompletableFuture<ResponseBytes<GetObjectResponse>> readAsync(long rangeStart, long rangeEnd) {
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(this.configProps.getBucket()).key(this.configProps.getKey()).range("bytes=" + rangeStart + "-" + rangeEnd).build();
        return this.client.getObject(request, AsyncResponseTransformer.toBytes());
    }

    protected void awaitCompletion(Map<Long, byte[]> data, Map<Long, CompletableFuture<ResponseBytes<GetObjectResponse>>> downloads) {
        boolean stillWaiting = true;
        ArrayList<Long> completed = new ArrayList<Long>(downloads.size());
        while (stillWaiting) {
            boolean allDone = true;
            for (Map.Entry<Long, CompletableFuture<ResponseBytes<GetObjectResponse>>> entry : downloads.entrySet()) {
                long key = entry.getKey();
                CompletableFuture<ResponseBytes<GetObjectResponse>> future = entry.getValue();
                if (future.isDone()) {
                    if (completed.contains(key)) continue;
                    try {
                        data.put(key, future.get().asByteArray());
                        completed.add(key);
                    }
                    catch (Exception e) {
                        LOGGER.warning("Unable to write data from S3 to the destination ByteBuffer. " + e.getMessage());
                    }
                    continue;
                }
                allDone = false;
            }
            stillWaiting = !allDone;
        }
    }

    public URL getURL() throws MalformedURLException {
        String scheme = this.uri.getScheme().toLowerCase();
        if (scheme.startsWith("s3")) {
            return new URL("https://" + this.configProps.getBucket() + ".s3." + this.configProps.getRegion() + ".amazonaws.com/" + this.configProps.getKey());
        }
        return super.getURL();
    }
}

