/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.core.SourceSPIProvider;
import it.geosolutions.imageio.plugins.cog.CogImageReadParam;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStream;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStreamSpi;
import it.geosolutions.imageioimpl.plugins.cog.RangeReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class CogSourceSPIProvider
extends SourceSPIProvider {
    private static final Logger LOGGER = Logger.getLogger(CogSourceSPIProvider.class.getName());
    private BasicAuthURI cogUri;
    private String rangeReaderClassname;
    private volatile URL cogURL;

    public CogSourceSPIProvider(BasicAuthURI cogUri, ImageReaderSpi readerSpi, ImageInputStreamSpi streamSpi, String rangeReader) {
        super((Object)cogUri, readerSpi, streamSpi);
        this.cogUri = cogUri;
        this.rangeReaderClassname = rangeReader;
    }

    public String getRangeReaderClassname() {
        return this.rangeReaderClassname;
    }

    public BasicAuthURI getCogUri() {
        return this.cogUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getSourceUrl() throws MalformedURLException {
        if (this.cogURL == null) {
            CogSourceSPIProvider cogSourceSPIProvider = this;
            synchronized (cogSourceSPIProvider) {
                if (this.cogURL == null) {
                    RangeReader reader = CogSourceSPIProvider.createRangeReaderInstance(this.rangeReaderClassname, this.cogUri, CogImageReadParam.DEFAULT_HEADER_LENGTH);
                    if (reader == null) {
                        return super.getSourceUrl();
                    }
                    this.cogURL = reader.getURL();
                }
            }
        }
        return this.cogURL;
    }

    public ImageInputStream getStream() throws IOException {
        BasicAuthURI uri = this.getCogUri();
        CogImageInputStream inStream = (CogImageInputStream)((CogImageInputStreamSpi)this.getStreamSpi()).createInputStreamInstance((Object)uri, uri.isUseCache(), null);
        RangeReader rangeReader = CogSourceSPIProvider.createRangeReaderInstance(this.rangeReaderClassname, uri, CogImageReadParam.DEFAULT_HEADER_LENGTH);
        if (rangeReader == null) {
            return null;
        }
        inStream.init(rangeReader);
        return inStream;
    }

    public static RangeReader createRangeReaderInstance(String className, BasicAuthURI uri, int headerLength) {
        RangeReader rangeReader = null;
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(BasicAuthURI.class, Integer.TYPE);
                rangeReader = (RangeReader)constructor.newInstance(uri, headerLength);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to create a RangeReader of type " + className + " on uri: " + uri.getUri().getPath() + " due to " + e.toString());
                }
                rangeReader = null;
            }
        }
        return rangeReader;
    }

    public CogSourceSPIProvider getCompatibleSourceProvider(URL url) {
        BasicAuthURI sourceURI = this.getCogUri();
        BasicAuthURI newSourceUri = new BasicAuthURI(url, sourceURI.isUseCache());
        newSourceUri.setPassword(sourceURI.getPassword());
        newSourceUri.setUser(sourceURI.getUser());
        return new CogSourceSPIProvider(newSourceUri, this.getReaderSpi(), this.getStreamSpi(), this.rangeReaderClassname);
    }
}

