/*
 *    ImageI/O-Ext - OpenSource Java Image translation Library
 *    http://www.geo-solutions.it/
 *    https://github.com/geosolutions-it/imageio-ext
 *    (C) 2007 - 2009, GeoSolutions
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    either version 3 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package it.geosolutions.imageio.plugins.geotiff;

import it.geosolutions.imageio.gdalframework.GDALImageWriterSpi;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;

/**
 * Class which provides a specialized Service Provider Interface which instantiates a {@link GeoTiffImageWriter}
 *
 * @author Daniele Romagnoli, GeoSolutions.
 * @author Simone Giannecchini, GeoSolutions.
 */
public final class GeoTiffImageWriterSpi extends GDALImageWriterSpi {
    static final String[] suffixes = {"GeoTiff", "tiff", "tif"};

    static final String[] formatNames = {"Tiff", "GeoTiff", "GeoTIFF", "GEOTIFF"};

    static final String[] MIMETypes = {"image/tiff"};

    static final String version = "1.0";

    static final String writerCN = "it.geosolutions.imageio.plugins.geotiff.GeoTiffImageWriter";

    static final String vendorName = "GeoSolutions";

    // ReaderSpiNames
    static final String[] readerSpiName = {"it.geosolutions.imageio.plugins.geotiff.GeoTiffImageReaderSpi"};

    // StreamMetadataFormatNames and StreamMetadataFormatClassNames
    static final boolean supportsStandardStreamMetadataFormat = false;

    static final String nativeStreamMetadataFormatName = null;

    static final String nativeStreamMetadataFormatClassName = null;

    static final String[] extraStreamMetadataFormatNames = null;

    static final String[] extraStreamMetadataFormatClassNames = null;

    // ImageMetadataFormatNames and ImageMetadataFormatClassNames
    static final boolean supportsStandardImageMetadataFormat = false;

    static final String nativeImageMetadataFormatName = null;

    static final String nativeImageMetadataFormatClassName = null;

    static final String[] extraImageMetadataFormatNames = {null};

    static final String[] extraImageMetadataFormatClassNames = {null};

    public GeoTiffImageWriterSpi() {
        super(
                vendorName,
                version,
                formatNames,
                suffixes,
                MIMETypes,
                writerCN,
                STANDARD_OUTPUT_TYPE,
                readerSpiName,
                supportsStandardStreamMetadataFormat,
                nativeStreamMetadataFormatName,
                nativeStreamMetadataFormatClassName,
                extraStreamMetadataFormatNames,
                extraStreamMetadataFormatClassNames,
                supportsStandardImageMetadataFormat,
                nativeImageMetadataFormatName,
                nativeImageMetadataFormatClassName,
                extraImageMetadataFormatNames,
                extraImageMetadataFormatClassNames,
                Collections.singletonList("GTiff"));
    }

    /** @see javax.imageio.spi.ImageWriterSpi#createWriterInstance(java.lang.Object) */
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return new GeoTiffImageWriter(this);
    }

    /** @see javax.imageio.spi.IIOServiceProvider#getDescription(java.util.Locale) */
    public String getDescription(Locale locale) {
        return "SPI for GeoTiff ImageWriter";
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return true;
    }
}
