/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.compression;

import it.geosolutions.imageio.compression.CompressionPrioritySpi;
import it.geosolutions.imageio.compression.CompressionType;
import it.geosolutions.imageio.registry.ImageIOEXTRegistry;
import it.geosolutions.imageio.registry.RegisterablePlugin;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractCompressionSpi
implements CompressionPrioritySpi,
RegisterablePlugin {
    protected boolean initialized;
    protected int priority = 50;

    protected abstract Set<CompressionType> getSupportedCompressions();

    protected void checkCompression(CompressionType compressionType) {
        if (!this.getSupportedCompressions().contains((Object)compressionType)) {
            throw new IllegalArgumentException("Unsupported Compression Type: " + compressionType + " Not in range: " + this.getSupportedCompressions().toString());
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.initialized = this.priority == priority;
        this.priority = priority;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public void onRegistration(ImageIOEXTRegistry imageIOEXTRegistry, Class<?> aClass) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (!this.isEnabled()) {
            imageIOEXTRegistry.deregisterSPI(this);
            return;
        }
        Iterator<?> spis = imageIOEXTRegistry.getSPIs(aClass, false);
        while (spis.hasNext()) {
            Object spi = spis.next();
            if (spi == this || !(spi instanceof AbstractCompressionSpi)) continue;
            AbstractCompressionSpi cpspi = (AbstractCompressionSpi)spi;
            int compare = cpspi.getPriority();
            if (this.getPriority() > compare) {
                imageIOEXTRegistry.setOrder(aClass, this, spi);
                continue;
            }
            imageIOEXTRegistry.setOrder(aClass, spi, this);
        }
    }

    @Override
    public void onDeregistration(ImageIOEXTRegistry imageIOEXTRegistry, Class<?> aClass) {
    }
}

