/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.grib1;

import it.geosolutions.imageio.ndplugin.BaseImageMetadata;
import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.grib1.GRIB1ImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GRIB1ImageMetadata
extends BaseImageMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_grib1_grib1ImageMetadata_1.0";
    private static final String driverName = "GRIB1";
    private static final String driverDescription = "Gridded Binary";
    public static final String GDS = "GridDefinitionSection";
    public static final String PDS = "ProductDefinitionSection";
    public static final String GRID_DELTA_X = "Dx";
    public static final String GRID_DELTA_Y = "Dy";
    public static final String GRID_N_X = "GridNX";
    public static final String GRID_N_Y = "GridNY";
    public static final String GRID_LAT_1 = "La1";
    public static final String GRID_LAT_2 = "La2";
    public static final String GRID_TYPE = "grid_type";
    public static final String GRID_LON_1 = "Lo1";
    public static final String GRID_LON_2 = "Lo2";
    public static final String GRID_LATIN_1 = "GridLatin1";
    public static final String GRID_LATIN_2 = "GridLatin2";
    public static final String GRID_STARTX = "GridStartX";
    public static final String GRID_STARTY = "GridStartY";
    public static final String GRID_LOV = "GridLov";
    public static final String GRID_ROTATION_ANGLE = "GridRotationAngle";
    public static final String GRID_LAT_SP = "GridLatSP";
    public static final String GRID_LON_SP = "GridLonSP";
    public static final String GRID_LAT_SPST = "GridLatSPST";
    public static final String GRID_LON_SPST = "GridLonSPST";
    public static final String PROD_TIME_RANGE_INDICATOR = "ProductTimeRangeIndicator";
    public static final String PROD_TIME = "ProductTime";
    public static final String PROD_TIME_NAME = "Time";
    public static final String PROD_TIME_UNITS = "TimeUnits";
    public static final String PROD_TIME_VALUES = "TimeValues";
    public static final String PROD_DEFINITION_TYPE = "DefinitionType";
    public static final String PROD_PARAMETER_DESCRIPTOR = "ParameterDescriptor";
    public static final String PROD_PARAMETER_NAME = "ParameterName";
    public static final String PROD_PARAMTABLE_CENTERID = "CenterID";
    public static final String PROD_PARAMTABLE_SUBCENTERID = "SubcenterID";
    public static final String PROD_PARAMTABLE_TABLEVERSION = "TableVersion";
    public static final String PROD_PARAMTABLE_PARAMETERNUMBER = "ParameterNumber";
    public static final String PROD_PARAMETER_UNIT = "Unit";
    public static final String PDS_LEVEL = "PDS_Level";
    public static final String PDSL_NAME = "name";
    public static final String PDSL_ID = "id";
    public static final String PDSL_ISNUMERIC = "isNumeric";
    public static final String PDSL_LEVEL = "level";
    public static final String PDSL_DESCRIPTION = "description";
    public static final String PDSL_UNITS = "units";
    public static final String PDSL_POSITIVE = "positive";
    public static final String PDSL_VALUES = "values";
    public static final String PDSL_AXISTYPE = "axisType";

    public GRIB1ImageMetadata(BaseImageReader reader, int imageIndex) {
        super(GRIB1ImageMetadata.checkReaderType(reader), imageIndex);
    }

    private static BaseImageReader checkReaderType(BaseImageReader reader) {
        if (reader instanceof GRIB1ImageReader) {
            return reader;
        }
        throw new IllegalArgumentException("Provided reader is of type " + reader.getClass().getCanonicalName());
    }

    protected void setMembers(BaseImageReader imageReader) throws IOException {
        super.setMembers(imageReader);
        if (imageReader instanceof GRIB1ImageReader) {
            int imageIndex = this.getImageIndex();
            GRIB1ImageReader reader = (GRIB1ImageReader)imageReader;
            this.setDatasetName(reader.getInnerReader().getVariableName(imageIndex));
            this.setDriverDescription(driverDescription);
            this.setDriverName(driverName);
        }
    }

    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createNativeTree();
        }
        if ("it_geosolutions_imageio_core_commonImageMetadata_1.0".equalsIgnoreCase(formatName)) {
            return super.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    private Node createNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode gdsNode = new IIOMetadataNode(GDS);
        GRIB1ImageReader directReader = (GRIB1ImageReader)this.imageReader;
        int imageIndex = this.getImageIndex();
        GRIB1ImageReader.GribVariableWrapper wrapper = (GRIB1ImageReader.GribVariableWrapper)directReader.getInnerReader().getVariableWrapper(imageIndex);
        List<NetCDFUtilities.KeyValuePair> coordsAttribute = directReader.getCoordinateAttributes();
        for (NetCDFUtilities.KeyValuePair pair : coordsAttribute) {
            gdsNode.setAttribute(pair.getKey(), pair.getValue());
        }
        root.appendChild(gdsNode);
        IIOMetadataNode pdsNode = new IIOMetadataNode(PDS);
        pdsNode.setAttribute(PROD_DEFINITION_TYPE, wrapper.getProductDefinitionType());
        pdsNode.setAttribute(PROD_TIME_NAME, wrapper.getTimeName());
        pdsNode.setAttribute(PROD_TIME_UNITS, wrapper.getTimeUnits());
        pdsNode.setAttribute(PROD_TIME_VALUES, wrapper.getTimeValues(imageIndex));
        pdsNode.setAttribute(PROD_PARAMETER_NAME, wrapper.getParameterName());
        pdsNode.setAttribute(PROD_PARAMTABLE_CENTERID, Integer.toString(wrapper.getParameterCenterID()));
        pdsNode.setAttribute(PROD_PARAMTABLE_TABLEVERSION, Integer.toString(wrapper.getParameterTableVersion()));
        pdsNode.setAttribute(PROD_PARAMTABLE_PARAMETERNUMBER, Integer.toString(wrapper.getParameterNumber()));
        pdsNode.setAttribute(PROD_PARAMETER_UNIT, wrapper.getParameterUnit());
        root.appendChild(pdsNode);
        IIOMetadataNode pdsLevelNode = new IIOMetadataNode(PDS_LEVEL);
        GRIB1ImageReader.VerticalLevel level = wrapper.getVerticalLevel();
        pdsLevelNode.setAttribute(PDSL_ID, Integer.toString(level.getLevelType()));
        pdsLevelNode.setAttribute(PDSL_NAME, level.getLevelName());
        pdsLevelNode.setAttribute(PDSL_DESCRIPTION, level.getLevelDescription());
        pdsLevelNode.setAttribute(PDSL_UNITS, level.getLevelUnits());
        pdsLevelNode.setAttribute(PDSL_ISNUMERIC, Boolean.toString(level.isHasExplicitVerticalAxis()));
        pdsLevelNode.setAttribute(PDSL_VALUES, wrapper.getLevelValues(imageIndex));
        pdsLevelNode.setAttribute(PDSL_POSITIVE, level.getPositive());
        pdsLevelNode.setAttribute(PDSL_AXISTYPE, level.getAxisType());
        root.appendChild(pdsLevelNode);
        return root;
    }
}

