/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.grib1;

import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.eclipse.imagen.RasterFactory;
import ucar.ma2.Array;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;

public class GRIB1Utilities {
    private static final ColorModel INT_COLOR_MODEL = GRIB1Utilities.buildColorModel(3);
    private static final ColorModel SHORT_COLOR_MODEL = GRIB1Utilities.buildColorModel(1);
    private static final ColorModel FLOAT_COLOR_MODEL = GRIB1Utilities.buildColorModel(4);
    private static final ColorModel DOUBLE_COLOR_MODEL = GRIB1Utilities.buildColorModel(5);
    static final String GRIB_PARAM_PREFIX = "GRIB_param_";
    static final String GRIB_PARAM_NUMBER = "GRIB_param_number";
    static final String GRIB_TABLE_ID = "GRIB_table_id";
    static final String GRIB_PARAM_NAME = "GRIB_param_name";
    static final String GRIB_PRODUCT_DEFINITION_TYPE = "GRIB_product_definition_type";
    static final String GRIB_PARAM_CENTER_ID = "GRIB_center_id";
    static final String GRIB_LEVEL_TYPE = "GRIB_level_type";
    static final String GRIB_PARAM_UNIT = "units";
    static final String BOUNDS = "bounds";
    static final int UNDEFINED_NUMBER = Integer.MIN_VALUE;
    public static final String VALUES_SEPARATOR = " ";

    public static ColorModel getColorModel(int type) {
        switch (type) {
            case 3: {
                return INT_COLOR_MODEL;
            }
            case 1: {
                return SHORT_COLOR_MODEL;
            }
            case 4: {
                return FLOAT_COLOR_MODEL;
            }
            case 5: {
                return DOUBLE_COLOR_MODEL;
            }
        }
        return GRIB1Utilities.buildColorModel(type);
    }

    private static ColorModel buildColorModel(int type) {
        return RasterFactory.createComponentColorModel((int)type, (ColorSpace)ColorSpace.getInstance(1003), (boolean)false, (boolean)false, (int)1);
    }

    private GRIB1Utilities() {
    }

    static final boolean isVerticalLevelSymbolic(int levelType) {
        switch (levelType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 102: 
            case 200: 
            case 201: 
            case 204: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 220: 
            case 222: 
            case 223: 
            case 224: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                return true;
            }
        }
        return false;
    }

    public static String getValuesAsString(Variable variable, int[] indexes) {
        int dataType = NetCDFUtilities.getRawDataType((VariableIF)variable);
        StringBuilder sb = new StringBuilder("");
        try {
            int size = indexes.length;
            Array values = variable.read();
            for (int i = 0; i < size; ++i) {
                switch (dataType) {
                    case 2: {
                        short val1s = values.getShort(indexes[i]);
                        sb.append(Short.toString(val1s));
                        break;
                    }
                    case 3: {
                        int val1 = values.getInt(indexes[i]);
                        sb.append(Integer.toString(val1));
                        break;
                    }
                    case 4: {
                        float val1f = values.getFloat(indexes[i]);
                        sb.append(Float.toString(val1f));
                        break;
                    }
                    case 5: {
                        double val1d = values.getDouble(indexes[i]);
                        sb.append(Double.toString(val1d));
                    }
                }
                if (size <= 1 || i == size - 1) continue;
                sb.append(VALUES_SEPARATOR);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

