/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.terascan;

import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.utilities.Utilities;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class HDF4TeraScanStreamMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_hdf4_terascan_TeraScanstreamMetadata_1.0";
    private BaseImageReader imageReader;
    public static final String GLOBAL_ATTRIBUTES = "GlobalAttributes";

    public HDF4TeraScanStreamMetadata(BaseImageReader imageReader) {
        this.imageReader = imageReader;
    }

    protected Node createCommonNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode(GLOBAL_ATTRIBUTES);
        if (this.imageReader instanceof HDF4TeraScanImageReader) {
            HDF4TeraScanImageReader reader = (HDF4TeraScanImageReader)this.imageReader;
            BaseNetCDFImageReader innerReader = reader.getInnerReader();
            int numAttributes = innerReader.getNumGlobalAttributes();
            try {
                for (int i = 0; i < numAttributes; ++i) {
                    NetCDFUtilities.KeyValuePair keyValuePair = innerReader.getGlobalAttribute(i);
                    String attribName = keyValuePair.getKey();
                    String attribValue = keyValuePair.getValue();
                    if (attribName.contains("\\")) {
                        attribName = Utilities.adjustAttributeName((String)attribName);
                    }
                    node.setAttribute(attribName, attribValue);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse attribute", e);
            }
            root.appendChild(node);
        }
        return root;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }
}

