/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.terascan;

import it.geosolutions.imageio.plugins.hdf4.HDF4Products;
import java.util.List;
import ucar.nc2.Variable;

public class HDF4TeraScanProperties {
    public static final TeraScanProducts terascanProducts = new TeraScanProducts();
    public static final String LOWER_LEFT_LONGITUDE = "lower_left_longitude";
    public static final String LOWER_LEFT_LATITUDE = "lower_left_latitude";
    public static final String UPPER_RIGHT_LONGITUDE = "upper_right_longitude";
    public static final String UPPER_RIGHT_LATITUDE = "upper_right_latitude";

    private HDF4TeraScanProperties() {
    }

    static String[] refineProductList(List<Variable> variables) {
        if (variables != null && !variables.isEmpty()) {
            int inputProducts = variables.size();
            String[] products = new String[inputProducts];
            int j = 0;
            boolean[] accepted = new boolean[inputProducts];
            for (int i = 0; i < inputProducts; ++i) {
                String productName;
                products[i] = productName = variables.get(i).getName();
                if (terascanProducts.get(productName) != null) {
                    accepted[i] = true;
                    ++j;
                    continue;
                }
                accepted[i] = false;
            }
            if (j == inputProducts) {
                return products;
            }
            String[] returnedProductsList = new String[j];
            j = 0;
            for (int i = 0; i < inputProducts; ++i) {
                if (!accepted[i]) continue;
                returnedProductsList[j++] = products[i];
            }
            return returnedProductsList;
        }
        return null;
    }

    public static class TeraScanProducts
    extends HDF4Products {
        public TeraScanProducts() {
            super(2);
            int i = 0;
            HDF4Products.HDF4Product mcsst = new HDF4Products.HDF4Product("mcsst", 1);
            this.add(i++, mcsst);
            HDF4Products.HDF4Product lowcloud = new HDF4Products.HDF4Product("lowcloud", 1);
            this.add(i++, lowcloud);
        }
    }

    public static class TemporalAttribs {
        public static final String PASS_START_DATE = "pass_start_date";
        public static final String PASS_START_TIME = "pass_start_time";
        public static final String DATA_START_DATE = "data_start_date";
        public static final String DATA_START_TIME = "data_start_time";
        public static final String DATA_END_DATE = "data_end_date";
        public static final String DATA_END_TIME = "data_end_time";

        private TemporalAttribs() {
        }
    }

    public static class ProjAttribs {
        public static final String PROJECT_TO_IMAGE_AFFINE = "proj_to_image_affine";
        public static final String PROJECT_ORIGIN_LATITUDE = "proj_origin_latitude";
        public static final String PROJECT_ORIGIN_LONGITUDE = "proj_origin_longitude";
        public static final String EARTH_FLATTENING = "earth_flattening";
        public static final String EQUATORIAL_RADIUS = "equatorial_radius";
        public static final String STANDARD_PARALLEL_1 = "std_parallel_1";
        public static final String STANDARD_PARALLEL_2 = "std_parallel_2";
        public static final String DATUM_NAME = "datum_name";
        public static final String PROJECTION_NAME = "projection_name";

        private ProjAttribs() {
        }
    }

    public static class DatasetAttribs {
        public static final String VALID_RANGE = "valid_range";
        public static final String LONG_NAME = "long_name";
        public static final String FILL_VALUE = "_FillValue";
        public static final String SCALE_FACTOR = "scale_factor";
        public static final String SCALE_FACTOR_ERR = "scale_factor_err";
        public static final String ADD_OFFSET = "add_offset";
        public static final String ADD_OFFSET_ERR = "add_offset_err";
        public static final String CALIBRATED_NT = "calibrated_nt";
        public static final String UNITS = "units";
        public static final String UNSIGNED = "_Unsigned";

        private DatasetAttribs() {
        }
    }
}

