/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.aps;

import it.geosolutions.imageio.ndplugin.BaseImageMetadata;
import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class HDF4APSImageMetadata
extends BaseImageMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_hdf4_aps_APSImageMetadata_1.0";
    private static final String driverName = "HDF4";
    private static final String driverDescription = "Hierarchical Data Format Release 4";
    private HashMap<String, String> additionalMetadata;
    private IIOMetadataNode nativeTree;

    public HDF4APSImageMetadata(BaseImageReader reader, int imageIndex) {
        super(reader, imageIndex);
    }

    protected void setMembers(BaseImageReader imageReader) throws IOException {
        super.setMembers(imageReader);
        int imageIndex = this.getImageIndex();
        if (imageReader instanceof HDF4APSImageReader) {
            String[] values;
            String validRange;
            String noData;
            String offset;
            HDF4APSImageReader reader = (HDF4APSImageReader)imageReader;
            BaseNetCDFImageReader innerReader = reader.getInnerReader();
            this.setDriverDescription(driverDescription);
            this.setDriverName(driverName);
            String scale = innerReader.getAttributeAsString(imageIndex, "scalingSlope");
            if (scale != null && scale.trim().length() > 0) {
                this.setScales(new Double[]{Double.parseDouble(scale)});
            }
            if ((offset = innerReader.getAttributeAsString(imageIndex, "scalingIntercept")) != null && offset.trim().length() > 0) {
                this.setOffsets(new Double[]{Double.parseDouble(offset)});
            }
            if ((noData = innerReader.getAttributeAsString(imageIndex, "invalid")) != null && noData.trim().length() > 0) {
                this.setNoDataValues(new Double[]{Double.parseDouble(noData)});
            }
            if ((validRange = innerReader.getAttributeAsString(imageIndex, "validRange")) == null || validRange.trim().length() < 1) {
                validRange = innerReader.getAttributeAsString(imageIndex, "browseRanges");
            }
            if (validRange != null && validRange.trim().length() > 0 && (values = validRange.split(",")).length == 2 && !values[0].equalsIgnoreCase(values[1])) {
                this.setMinimums(new Double[]{Double.parseDouble(values[0])});
                this.setMaximums(new Double[]{Double.parseDouble(values[1])});
            }
            this.setDatasetName(reader.getDatasetName(imageIndex));
            this.setNumOverviews(new int[]{0});
            int numAttributes = innerReader.getNumAttributes(imageIndex);
            this.additionalMetadata = new HashMap(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                NetCDFUtilities.KeyValuePair attributePair = innerReader.getAttribute(imageIndex, i);
                String attributeName = attributePair.getKey();
                String attributeValue = attributePair.getValue();
                this.additionalMetadata.put(attributeName, attributeValue);
            }
        }
    }

    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createNativeTree();
        }
        if ("it_geosolutions_imageio_core_commonImageMetadata_1.0".equalsIgnoreCase(formatName)) {
            return super.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    private synchronized Node createNativeTree() {
        if (this.nativeTree != null) {
            return this.nativeTree;
        }
        this.nativeTree = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.additionalMetadata != null) {
            IIOMetadataNode node = new IIOMetadataNode("Attributes");
            for (String key : this.additionalMetadata.keySet()) {
                String attributeValue = this.additionalMetadata.get(key);
                node.setAttribute(key, attributeValue);
            }
            this.nativeTree.appendChild(node);
        }
        return this.nativeTree;
    }
}

