/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.terascan;

import it.geosolutions.imageio.plugins.hdf4.HDF4ImageReaderSpi;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanImageReader;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanProperties;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import ucar.nc2.dataset.NetcdfDataset;

public class HDF4TeraScanImageReaderSpi
extends HDF4ImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger(HDF4TeraScanImageReaderSpi.class.toString());
    static final String readerCN = "it.geosolutions.imageio.plugins.hdf4.HDF4TeraScanImageReader";

    public HDF4TeraScanImageReaderSpi() {
        super(readerCN);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("HDF4TeraScanImageReaderSpi Constructor");
        }
    }

    @Override
    protected boolean isValidDataset(NetcdfDataset dataset) {
        boolean found = false;
        int productsNum = HDF4TeraScanProperties.terascanProducts.getNProducts();
        for (int i = 0; i < productsNum; ++i) {
            if (dataset.findVariable(HDF4TeraScanProperties.terascanProducts.get(i).getProductName()) == null) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public ImageReader createReaderInstance(Object input) throws IOException {
        return new HDF4TeraScanImageReader((ImageReaderSpi)((Object)this));
    }
}

