/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.terascan;

import it.geosolutions.imageio.ndplugin.BaseImageMetadata;
import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class HDF4TeraScanImageMetadata
extends BaseImageMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_hdf4_terascan_terascanImageMetadata_1.0";
    private static final String driverName = "HDF4";
    private static final String driverDescription = "Hierarchical Data Format Release 4";
    private HashMap<String, String> additionalMetadata;
    private IIOMetadataNode nativeTree;

    public HDF4TeraScanImageMetadata(BaseImageReader reader, int imageIndex) {
        super(reader, imageIndex);
    }

    protected void setMembers(BaseImageReader imageReader) throws IOException {
        super.setMembers(imageReader);
        int imageIndex = this.getImageIndex();
        if (imageReader instanceof HDF4TeraScanImageReader) {
            double[] validRange;
            double noData;
            String name;
            double offset;
            HDF4TeraScanImageReader reader = (HDF4TeraScanImageReader)imageReader;
            BaseNetCDFImageReader innerReader = reader.getInnerReader();
            this.setDriverDescription(driverDescription);
            this.setDriverName(driverName);
            double scale = reader.getScale(imageIndex);
            if (!Double.isNaN(scale)) {
                this.setScales(new Double[]{scale});
            }
            if (!Double.isNaN(offset = reader.getOffset(imageIndex))) {
                this.setOffsets(new Double[]{offset});
            }
            if ((name = reader.getLongName(imageIndex)) != null && name.trim().length() > 0) {
                this.setDatasetName(name);
            }
            if (!Double.isNaN(noData = reader.getFillValue(imageIndex))) {
                this.setNoDataValues(new Double[]{noData});
            }
            if ((validRange = reader.getValidRange(imageIndex)) != null && validRange.length == 2 && !Double.isNaN(validRange[0]) && !Double.isNaN(validRange[1])) {
                this.setMinimums(new Double[]{validRange[0]});
                this.setMaximums(new Double[]{validRange[1]});
            }
            this.setNumOverviews(new int[]{0});
            int numAttributes = innerReader.getNumAttributes(imageIndex);
            this.additionalMetadata = new HashMap(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                NetCDFUtilities.KeyValuePair attributePair = innerReader.getAttribute(imageIndex, i);
                String attributeName = attributePair.getKey();
                String attributeValue = attributePair.getValue();
                this.additionalMetadata.put(attributeName, attributeValue);
            }
        }
    }

    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createNativeTree();
        }
        if ("it_geosolutions_imageio_core_commonImageMetadata_1.0".equalsIgnoreCase(formatName)) {
            return super.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    private Node createNativeTree() {
        if (this.nativeTree != null) {
            return this.nativeTree;
        }
        this.nativeTree = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.additionalMetadata != null) {
            IIOMetadataNode node = new IIOMetadataNode("Attributes");
            for (String key : this.additionalMetadata.keySet()) {
                String attributeValue = this.additionalMetadata.get(key);
                node.setAttribute(key, attributeValue);
            }
            this.nativeTree.appendChild(node);
        }
        return this.nativeTree;
    }
}

