/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.aps;

import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSImageReader;
import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSProperties;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class HDF4APSStreamMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_hdf4_aps_APSStreamMetadata_1.0";
    public static final String PFA_NODE = "ProductFilesAttributes";
    public static final String PFA_IPA_NODE = "InputParameterAttributes";
    public static final String DATUM = "Datum";
    public static final String PROJECTION = "Projection";
    public static final String SEMI_MAJOR_AXIS = "Param0";
    public static final String SEMI_MINOR_AXIS = "Param1";
    public static final String LONGITUDE_OF_CENTRAL_MERIDIAN = "LongitudeOfCentralMeridian";
    public static final String LATITUDE_OF_TRUE_SCALE = "LatitudeOfTrueScale";
    public static final String FALSE_EASTINGS = "FalseEastings";
    public static final String FALSE_NORTHINGS = "FalseNorthings";
    public static final String STD_NODE = "StandardAPSAttributes";
    public static final String PFA_NA_NODE = "NavigationAttributes";
    public static final String STD_FA_NODE = "FileAttributes";
    public static final String STD_TA_NODE = "TimeAttributes";
    public static final String STD_SA_NODE = "SensorAttributes";
    public static final String REFERENCING_NODE = "Referencing";
    public static final String PFA_IGCA_NODE = "InputGeographicalCoverageAttributes";
    public static final String GENERICS_NODE = "GenericAttributes";
    public static final String PROJECTION_NODE = "Projection";
    public static final String ZONE = "Zone";
    public static final String MAP_UPPER_RIGHT = "mapUpperRight";
    public static final String MAP_LOWER_LEFT = "mapLowerLeft";
    private Map<String, String> stdFileAttribMap = new LinkedHashMap<String, String>(11);
    private Map<String, String> stdTimeAttribMap = new LinkedHashMap<String, String>(9);
    private Map<String, String> stdSensorAttribMap = new LinkedHashMap<String, String>(13);
    private Map<String, String> fileInputParamAttribMap = new LinkedHashMap<String, String>(6);
    private Map<String, String> fileNavAttribMap = new LinkedHashMap<String, String>(7);
    private Map<String, String> fileInGeoCovAttribMap = new LinkedHashMap<String, String>(8);
    private Map<String, String> genericAttribMap = new LinkedHashMap<String, String>(15);
    private Map<String, String> projectionMap = null;
    private Map<String, ArrayList<Map<String, String>>> productsMap = null;
    private String[] prodList = null;
    private int prodListNum;
    private String projectionDatasetName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIOMetadataNode buildAttributesNodeFromMap(Map<String, String> attribMap, String nodeName) {
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        Map<String, String> map = attribMap;
        synchronized (map) {
            if (attribMap != null) {
                Set<String> set = attribMap.keySet();
                for (String key : set) {
                    String attribValue = attribMap.get(key);
                    key = key.replace('\\', '_');
                    node.setAttribute(key, attribValue);
                }
            }
        }
        return node;
    }

    public HDF4APSStreamMetadata() {
        super(false, nativeMetadataFormatName, null, null, null);
    }

    public HDF4APSStreamMetadata(HDF4APSImageReader reader) {
        this();
        this.buildMetadata(reader);
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private synchronized Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode attribNode = new IIOMetadataNode("Attributes");
        IIOMetadataNode stdNode = new IIOMetadataNode(STD_NODE);
        IIOMetadataNode stdFaNode = this.buildAttributesNodeFromMap(this.stdFileAttribMap, STD_FA_NODE);
        stdNode.appendChild(stdFaNode);
        IIOMetadataNode stdTaNode = this.buildAttributesNodeFromMap(this.stdTimeAttribMap, STD_TA_NODE);
        stdNode.appendChild(stdTaNode);
        IIOMetadataNode stdSaNode = this.buildAttributesNodeFromMap(this.stdSensorAttribMap, STD_SA_NODE);
        stdNode.appendChild(stdSaNode);
        attribNode.appendChild(stdNode);
        IIOMetadataNode fpaNode = new IIOMetadataNode(PFA_NODE);
        IIOMetadataNode fpIpaNode = this.buildAttributesNodeFromMap(this.fileInputParamAttribMap, PFA_IPA_NODE);
        fpaNode.appendChild(fpIpaNode);
        IIOMetadataNode fpNaNode = this.buildAttributesNodeFromMap(this.fileNavAttribMap, PFA_NA_NODE);
        fpaNode.appendChild(fpNaNode);
        IIOMetadataNode fpIgcaNode = this.buildAttributesNodeFromMap(this.fileInGeoCovAttribMap, PFA_IGCA_NODE);
        fpaNode.appendChild(fpIgcaNode);
        attribNode.appendChild(fpaNode);
        IIOMetadataNode genericNode = this.buildAttributesNodeFromMap(this.genericAttribMap, GENERICS_NODE);
        attribNode.appendChild(genericNode);
        root.appendChild(attribNode);
        IIOMetadataNode referencingNode = new IIOMetadataNode(REFERENCING_NODE);
        IIOMetadataNode projectionNode = this.buildAttributesNodeFromMap(this.projectionMap, "Projection");
        referencingNode.appendChild(projectionNode);
        root.appendChild(referencingNode);
        return root;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }

    synchronized void buildMetadata(HDF4APSImageReader reader) {
        try {
            BaseNetCDFImageReader innerReader = reader.getInnerReader();
            int numAttributes = innerReader.getNumGlobalAttributes();
            int nStdFileAttribMap = HDF4APSProperties.STD_FA_ATTRIB.length;
            int nStdTimeAttribMap = HDF4APSProperties.STD_TA_ATTRIB.length;
            int nStdSensorAttribMap = HDF4APSProperties.STD_SA_ATTRIB.length;
            int nFileInputParamAttribMap = HDF4APSProperties.PFA_IPA_ATTRIB.length;
            int nFileNavAttribMap = HDF4APSProperties.PFA_NA_ATTRIB.length;
            int nFileInGeoCovAttribMap = HDF4APSProperties.PFA_IGCA_ATTRIB.length;
            for (int i = 0; i < numAttributes; ++i) {
                int k;
                NetCDFUtilities.KeyValuePair keyValuePair = innerReader.getGlobalAttribute(i);
                String attribName = keyValuePair.getKey();
                String attribValue = keyValuePair.getValue();
                boolean found = false;
                for (k = 0; k < nStdFileAttribMap && !found; ++k) {
                    if (!attribName.equals(HDF4APSProperties.STD_FA_ATTRIB[k])) continue;
                    this.stdFileAttribMap.put(attribName, attribValue);
                    found = true;
                }
                for (k = 0; k < nStdTimeAttribMap && !found; ++k) {
                    if (!attribName.equals(HDF4APSProperties.STD_TA_ATTRIB[k])) continue;
                    this.stdTimeAttribMap.put(attribName, attribValue);
                    found = true;
                }
                for (k = 0; k < nStdSensorAttribMap && !found; ++k) {
                    if (!attribName.equals(HDF4APSProperties.STD_SA_ATTRIB[k])) continue;
                    this.stdSensorAttribMap.put(attribName, attribValue);
                    found = true;
                }
                for (k = 0; k < nFileInputParamAttribMap && !found; ++k) {
                    if (!attribName.equals(HDF4APSProperties.PFA_IPA_ATTRIB[k])) continue;
                    this.fileInputParamAttribMap.put(attribName, attribValue);
                    if (attribName.equals("prodList")) {
                        String[] products = attribValue.split(",");
                        this.prodList = HDF4APSProperties.refineProductList(products);
                    }
                    found = true;
                }
                for (k = 0; k < nFileNavAttribMap && !found; ++k) {
                    if (!attribName.equals(HDF4APSProperties.PFA_NA_ATTRIB[k])) continue;
                    this.fileNavAttribMap.put(attribName, attribValue);
                    if (attribName.equals("mapProjection")) {
                        this.projectionDatasetName = attribValue;
                    }
                    found = true;
                }
                for (k = 0; k < nFileInGeoCovAttribMap && !found; ++k) {
                    if (!attribName.equals(HDF4APSProperties.PFA_IGCA_ATTRIB[k])) continue;
                    this.fileInGeoCovAttribMap.put(attribName, attribValue);
                    found = true;
                }
                if (found) continue;
                this.genericAttribMap.put(attribName, attribValue);
            }
            Map<String, String> originalMap = reader.projectionMap;
            this.projectionMap = new LinkedHashMap<String, String>(originalMap.size());
            for (String key : originalMap.keySet()) {
                String value = originalMap.get(key);
                this.projectionMap.put(key, value);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Errors while getting access to HDF during StreamMetadata setting", e);
        }
    }
}

