/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.aps;

import it.geosolutions.imageio.plugins.hdf4.BaseHDF4ImageReader;
import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSImageMetadata;
import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSProperties;
import it.geosolutions.imageio.plugins.hdf4.aps.HDF4APSStreamMetadata;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.NetcdfDataset;

public class HDF4APSImageReader
extends BaseHDF4ImageReader {
    private String[] productList;
    private String projectionDatasetName;
    private HDF4APSStreamMetadata streamMetadata;
    Map<String, String> projectionMap = null;

    BaseNetCDFImageReader getInnerReader() {
        return this.reader;
    }

    @Override
    protected void initializeProfile() throws IOException {
        NetcdfDataset dataset = this.reader.getDataset();
        if (dataset == null) {
            throw new IOException("Unable to initialize profile due to a null dataset");
        }
        List variables = dataset.getVariables();
        List attributes = dataset.getGlobalAttributes();
        int numVars = variables.size();
        this.reader.setNumGlobalAttributes(attributes.size());
        String navAttrib = NetCDFUtilities.getGlobalAttributeAsString((NetcdfDataset)dataset, (String)"mapProjection");
        if (navAttrib != null && navAttrib.length() > 0) {
            this.projectionDatasetName = navAttrib;
        }
        String prodAttrib = NetCDFUtilities.getGlobalAttributeAsString((NetcdfDataset)dataset, (String)"prodList");
        int numImages = 0;
        if (prodAttrib != null && prodAttrib.length() > 0) {
            String[] products = prodAttrib.split(",");
            this.productList = HDF4APSProperties.refineProductList(products);
            numImages = this.productList.length;
        } else {
            numImages = numVars;
        }
        this.setNumImages(numImages);
        this.reader.setNumImages(numImages);
        HashMap<Range, APSDatasetWrapper> indexMap = new HashMap<Range, APSDatasetWrapper>(numImages);
        Variable varProjection = dataset.findVariable(this.projectionDatasetName);
        if (varProjection != null && varProjection.getName().equalsIgnoreCase(this.projectionDatasetName)) {
            Array data = varProjection.read();
            int datatype = NetCDFUtilities.getRawDataType((VariableIF)varProjection);
            if (this.projectionMap == null) {
                this.projectionMap = HDF4APSImageReader.buildProjectionAttributesMap(data, datatype);
            }
        }
        try {
            block2: for (Variable var : variables) {
                String name = var.getName();
                for (int j = 0; j < numImages; ++j) {
                    if (!name.equals(this.productList[j])) continue;
                    indexMap.put(new Range(j, j + 1), new APSDatasetWrapper(var));
                    continue block2;
                }
            }
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException("Error occurred during NetCDF file parsing", e);
        }
        this.reader.setIndexMap(indexMap);
    }

    private static Map<String, String> buildProjectionAttributesMap(Array data, int datatype) {
        LinkedHashMap<String, String> projMap = new LinkedHashMap<String, String>(29);
        if (datatype == 5 && data instanceof ArrayDouble) {
            double[] values = (double[])data.get1DJavaArray(Double.TYPE);
            projMap.put("Code", Double.toString(values[0]));
            projMap.put("Projection", Double.toString(values[1]));
            projMap.put("Zone", Double.toString(values[2]));
            projMap.put("Datum", Double.toString(values[3]));
            projMap.put("Param0", Double.toString(values[4]));
            projMap.put("Param1", Double.toString(values[5]));
            projMap.put("Param2", Double.toString(values[6]));
            projMap.put("Param3", Double.toString(values[7]));
            projMap.put("LongitudeOfCentralMeridian", Double.toString(values[8]));
            projMap.put("LatitudeOfTrueScale", Double.toString(values[9]));
            projMap.put("FalseEastings", Double.toString(values[10]));
            projMap.put("FalseNorthings", Double.toString(values[11]));
            projMap.put("Param8", Double.toString(values[12]));
            projMap.put("Param9", Double.toString(values[13]));
            projMap.put("Param10", Double.toString(values[14]));
            projMap.put("Param11", Double.toString(values[15]));
            projMap.put("Param12", Double.toString(values[16]));
            projMap.put("Param13", Double.toString(values[17]));
            projMap.put("Param14", Double.toString(values[18]));
            projMap.put("Width", Double.toString(values[19]));
            projMap.put("Height", Double.toString(values[20]));
            projMap.put("Longitude_1", Double.toString(values[21]));
            projMap.put("Latitude_1", Double.toString(values[22]));
            projMap.put("Pixel_1", Double.toString(values[23]));
            projMap.put("Line_1", Double.toString(values[24]));
            projMap.put("Longitude_2", Double.toString(values[25]));
            projMap.put("Latitude_2", Double.toString(values[26]));
            projMap.put("Delta", Double.toString(values[27]));
            projMap.put("Aspect", Double.toString(values[28]));
        }
        return projMap;
    }

    public HDF4APSImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected int getBandNumberFromProduct(String productName) {
        return HDF4APSProperties.apsProducts.get(productName).getNBands();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.productList = null;
        this.streamMetadata = null;
    }

    String getDatasetName(int imageIndex) {
        this.checkImageIndex(imageIndex);
        String datasetName = "";
        APSDatasetWrapper wrapper = (APSDatasetWrapper)this.getDatasetWrapper(imageIndex);
        if (wrapper != null) {
            datasetName = wrapper.getVariable().getName();
        }
        return datasetName;
    }

    public void reset() {
        super.reset();
    }

    public IIOMetadata getImageMetadata(int imageIndex, String formatName, Set<String> nodeNames) throws IOException {
        this.initialize();
        this.checkImageIndex(imageIndex);
        if (formatName.equalsIgnoreCase("it_geosolutions_imageio_plugins_hdf4_aps_APSImageMetadata_1.0")) {
            return new HDF4APSImageMetadata(this, imageIndex);
        }
        return super.getImageMetadata(imageIndex, formatName, nodeNames);
    }

    public synchronized IIOMetadata getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        if (formatName.equalsIgnoreCase("it_geosolutions_imageio_plugins_hdf4_aps_APSStreamMetadata_1.0")) {
            if (this.streamMetadata == null) {
                this.streamMetadata = new HDF4APSStreamMetadata(this);
            }
            return this.streamMetadata;
        }
        return super.getStreamMetadata(formatName, nodeNames);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.getImageMetadata(imageIndex, "it_geosolutions_imageio_plugins_hdf4_aps_APSImageMetadata_1.0", null);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex, String format) throws IOException {
        return this.getImageMetadata(imageIndex, format, null);
    }

    @Override
    public synchronized IIOMetadata getStreamMetadata() throws IOException {
        return this.getStreamMetadata("it_geosolutions_imageio_plugins_hdf4_aps_APSStreamMetadata_1.0", null);
    }

    @Override
    protected BaseHDF4ImageReader.HDF4DatasetWrapper getDatasetWrapper(int imageIndex) {
        return (BaseHDF4ImageReader.HDF4DatasetWrapper)this.reader.getVariableWrapper(imageIndex);
    }

    private class APSDatasetWrapper
    extends BaseHDF4ImageReader.HDF4DatasetWrapper {
        private APSDatasetWrapper(Variable var) {
            super(HDF4APSImageReader.this, var);
        }
    }
}

