/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.ChannelDefinitionBox;
import javax.imageio.metadata.IIOMetadataNode;

public class ChannelDefinitionBoxMetadataNode
extends BaseJP2KBoxMetadataNode {
    private short numChannels;
    private String numberOfChannelDefinitions;
    private String[] channels;
    private String[] types;
    private String[] associations;

    public ChannelDefinitionBoxMetadataNode(ChannelDefinitionBox box) {
        super(box);
        this.numChannels = box.getNum();
        short[] channel = box.getChannel();
        short[] assoc = box.getAssociation();
        int[] type = box.getTypes();
        IIOMetadataNode child = new IIOMetadataNode("NumberOfChannelDefinition");
        child.setUserObject(new Short(this.numChannels));
        this.numberOfChannelDefinitions = Short.toString(this.numChannels);
        this.channels = new String[this.numChannels];
        this.types = new String[this.numChannels];
        this.associations = new String[this.numChannels];
        child.setNodeValue(this.numberOfChannelDefinitions);
        this.appendChild(child);
        child = new IIOMetadataNode("Definitions");
        this.appendChild(child);
        for (int i = 0; i < this.numChannels; ++i) {
            IIOMetadataNode child1 = new IIOMetadataNode("ChannelNumber");
            child1.setUserObject(new Short(channel[i]));
            this.channels[i] = Short.toString(channel[i]);
            child1.setNodeValue(this.channels[i]);
            child.appendChild(child1);
            child1 = new IIOMetadataNode("ChannelType");
            child1.setUserObject(new Integer(type[i]));
            this.types[i] = Integer.toString(type[i]);
            child1.setNodeValue(this.types[i]);
            child.appendChild(child1);
            child1 = new IIOMetadataNode("Association");
            child1.setUserObject(new Short(assoc[i]));
            this.associations[i] = Short.toString(assoc[i]);
            child1.setNodeValue(this.associations[i]);
            child.appendChild(child1);
        }
    }

    public String getChannel(int index) {
        if (index > this.numChannels - 1) {
            throw new IllegalArgumentException("Number of channel descriptions is " + this.numChannels);
        }
        return this.channels[index];
    }

    public String getType(int index) {
        if (index > this.numChannels - 1) {
            throw new IllegalArgumentException("Number of channel descriptions is " + this.numChannels);
        }
        return this.types[index];
    }

    public String getAssociation(int index) {
        if (index > this.numChannels - 1) {
            throw new IllegalArgumentException("Number of channel descriptions is " + this.numChannels);
        }
        return this.associations[index];
    }

    public String getNumberOfChannelDefinitions() {
        return this.numberOfChannelDefinitions;
    }
}

