/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LabelBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1818389536;
    public static final String NAME = "lbl ";
    public static final String JP2K_MD_NAME = "JP2KLabelBox";
    private static String[] elementNames = new String[]{"Text"};
    private byte[] localData;
    private String text;

    public static String[] getElementNames() {
        return elementNames;
    }

    public LabelBox(byte[] data) {
        super(8 + data.length, 1818389536, data);
    }

    public LabelBox(String text) {
        super(2 * text.length(), 1818389536, text.getBytes());
        this.text = text;
    }

    public LabelBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!"Text".equals(name)) continue;
            this.text = BoxUtilities.getStringElementValue(child);
        }
    }

    @Override
    protected void parse(byte[] data) {
        this.text = new String(data);
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    @Override
    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = this.text.getBytes();
        return this.localData;
    }

    public String getText() {
        return this.text;
    }
}

