/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDListBox;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import javax.imageio.metadata.IIOMetadataNode;

public class UUIDListBoxMetadataNode
extends BaseJP2KBoxMetadataNode {
    private String numberUUID;
    private short nUid;
    private String[] uuid;

    UUIDListBoxMetadataNode(UUIDListBox box) {
        super(box);
        this.nUid = box.getNum();
        this.numberUUID = Short.toString(this.nUid);
        byte[][] uuids = box.getUuids();
        this.uuid = new String[this.nUid];
        IIOMetadataNode child = new IIOMetadataNode("NumberUUID");
        child.setUserObject(new Short(this.nUid));
        child.setNodeValue(this.numberUUID);
        this.appendChild(child);
        for (int i = 0; i < this.nUid; ++i) {
            child = new IIOMetadataNode("UUID");
            if (uuids[i] != null) {
                child.setUserObject(uuids[i].clone());
            }
            this.uuid[i] = ImageIOUtilities.convertObjectToString((Object)uuids[i]);
            child.setNodeValue(this.uuid[i]);
            this.appendChild(child);
        }
    }

    public String getNumberUUID() {
        return this.numberUUID;
    }

    public String getUuid(int index) {
        if (index > this.nUid - 1) {
            throw new IllegalArgumentException("Number of UUID is " + this.numberUUID);
        }
        return this.uuid[index];
    }
}

