/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.PaletteBoxMetadataNode;
import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaletteBox
extends BaseJP2KBox {
    public static final int BOX_TYPE = 1885564018;
    public static final String NAME = "pclr";
    public static final String JP2K_MD_NAME = "JP2KPaletteBox";
    private int numEntries;
    private int numComps;
    private byte[] bitDepth;
    private byte[][] lut;
    private byte[] localdata;

    private static int computeLength(IndexColorModel icm) {
        int size = icm.getMapSize();
        int[] comp = icm.getComponentSize();
        return 11 + comp.length + size * comp.length;
    }

    private static byte[] getCompSize(IndexColorModel icm) {
        int[] comp = icm.getComponentSize();
        int size = comp.length;
        byte[] buf = new byte[size];
        for (int i = 0; i < size; ++i) {
            buf[i] = (byte)(comp[i] - 1);
        }
        return buf;
    }

    private static byte[][] getLUT(IndexColorModel icm) {
        int[] comp = icm.getComponentSize();
        int size = icm.getMapSize();
        byte[][] lut = new byte[comp.length][size];
        icm.getReds(lut[0]);
        icm.getGreens(lut[1]);
        icm.getBlues(lut[2]);
        if (comp.length == 4) {
            icm.getAlphas(lut[3]);
        }
        return lut;
    }

    public PaletteBox(IndexColorModel icm) {
        this(PaletteBox.computeLength(icm), PaletteBox.getCompSize(icm), PaletteBox.getLUT(icm));
    }

    public PaletteBox(Node node) throws IIOInvalidTreeException {
        super(node);
        int i;
        byte[][] tlut = null;
        int index = 0;
        NodeList children = node.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("NumberEntries".equals(name)) {
                this.numEntries = BoxUtilities.getIntElementValue(child);
            }
            if ("NumberColors".equals(name)) {
                this.numComps = BoxUtilities.getIntElementValue(child);
            }
            if ("BitDepth".equals(name)) {
                this.bitDepth = BoxUtilities.getByteArrayElementValue(child);
            }
            if (!"LUT".equals(name)) continue;
            tlut = new byte[this.numEntries][];
            NodeList children1 = child.getChildNodes();
            for (int j = 0; j < children1.getLength(); ++j) {
                Node child1 = children1.item(j);
                name = child1.getNodeName();
                if (!"LUTRow".equals(name)) continue;
                tlut[index++] = BoxUtilities.getByteArrayElementValue(child1);
            }
        }
        this.lut = new byte[this.numComps][this.numEntries];
        for (i = 0; i < this.numComps; ++i) {
            for (int j = 0; j < this.numEntries; ++j) {
                this.lut[i][j] = tlut[j][i];
            }
        }
    }

    public PaletteBox(int length, byte[] comp, byte[][] lut) {
        super(length, 1885564018, null);
        this.bitDepth = comp;
        this.lut = lut;
        this.numEntries = lut[0].length;
        this.numComps = lut.length;
    }

    public PaletteBox(byte[] data) {
        super(8 + data.length, 1885564018, data);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getNumComp() {
        return this.numComps;
    }

    public byte[] getBitDepths() {
        return this.bitDepth;
    }

    public byte[][] getLUT() {
        return this.lut;
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return new PaletteBoxMetadataNode(this);
    }

    @Override
    protected void parse(byte[] data) {
        if (data == null) {
            return;
        }
        this.numEntries = (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        this.numComps = data[2];
        this.bitDepth = new byte[this.numComps];
        System.arraycopy(data, 3, this.bitDepth, 0, this.numComps);
        this.lut = new byte[this.numComps][this.numEntries];
        int k = 3 + this.numComps;
        for (int i = 0; i < this.numEntries; ++i) {
            for (int j = 0; j < this.numComps; ++j) {
                this.lut[j][i] = data[k++];
            }
        }
    }

    @Override
    protected synchronized byte[] compose() {
        if (this.localdata != null) {
            return this.localdata;
        }
        this.localdata = new byte[3 + this.numComps + this.numEntries * this.numComps];
        this.localdata[0] = (byte)(this.numEntries >> 8);
        this.localdata[1] = (byte)(this.numEntries & 0xFF);
        this.localdata[2] = (byte)this.numComps;
        System.arraycopy(this.bitDepth, 0, this.localdata, 3, this.numComps);
        int k = 3 + this.numComps;
        for (int i = 0; i < this.numEntries; ++i) {
            for (int j = 0; j < this.numComps; ++j) {
                this.localdata[k++] = this.lut[j][i];
            }
        }
        return this.localdata;
    }
}

