/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.ResolutionBoxMetadataNode;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolutionBox
extends BaseJP2KBox {
    private short numV;
    private short numH;
    private short denomV;
    private short denomH;
    private byte expV;
    private byte expH;
    public static final int BOX_TYPE = 1919251232;
    public static final int BOX_TYPE_CAPTURE = 1919251299;
    public static final int BOX_TYPE_DEFAULT_DISPLAY = 1919251300;
    public static final String NAME = "res ";
    public static final String CAP_NAME = "resc";
    public static final String DEF_NAME = "resd";
    public static final String JP2K_MD_NAME = "JP2KResolutionBox";
    public static final String JP2_MD_CAP_NAME = "JP2KCaptureResolutionBox";
    public static final String JP2_MD_DEF_DISP_NAME = "JP2KDefaultDisplayResolutionBox";
    private float hRes;
    private float vRes;
    private byte[] localData;

    public ResolutionBox(int type, byte[] data) {
        super(8 + data.length, type, data);
    }

    public ResolutionBox(byte[] data) {
        this(1919251232, data);
    }

    public ResolutionBox(int type, float hRes, float vRes) {
        super(26, type, null);
        int temp;
        this.hRes = hRes;
        this.vRes = vRes;
        this.denomV = 1;
        this.denomH = 1;
        this.expV = 0;
        if (vRes >= 32768.0f) {
            for (temp = (int)vRes; temp >= 32768; temp /= 10) {
                this.expV = (byte)(this.expV + 1);
            }
            this.numV = (short)(temp & 0xFFFF);
        } else {
            this.numV = (short)vRes;
        }
        this.expH = 0;
        if (hRes >= 32768.0f) {
            for (temp = (int)hRes; temp >= 32768; temp /= 10) {
                this.expH = (byte)(this.expH + 1);
            }
            this.numH = (short)(temp & 0xFFFF);
        } else {
            this.numH = (short)hRes;
        }
    }

    public ResolutionBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("VerticalResolutionNumerator".equals(name)) {
                this.numV = BoxUtilities.getShortElementValue(child);
            }
            if ("VerticalResolutionDenominator".equals(name)) {
                this.denomV = BoxUtilities.getShortElementValue(child);
            }
            if ("HorizontalResolutionNumerator".equals(name)) {
                this.numH = BoxUtilities.getShortElementValue(child);
            }
            if ("HorizontalResolutionDenominator".equals(name)) {
                this.denomH = BoxUtilities.getShortElementValue(child);
            }
            if ("VerticalResolutionExponent".equals(name)) {
                this.expV = BoxUtilities.getByteElementValue(child);
            }
            if (!"HorizontalResolutionExponent".equals(name)) continue;
            this.expH = BoxUtilities.getByteElementValue(child);
        }
    }

    public float getHorizontalResolution() {
        return this.hRes;
    }

    public float getVerticalResolution() {
        return this.vRes;
    }

    @Override
    protected void parse(byte[] data) {
        this.numV = (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        this.denomV = (short)((data[2] & 0xFF) << 8 | data[3] & 0xFF);
        this.numH = (short)((data[4] & 0xFF) << 8 | data[5] & 0xFF);
        this.denomH = (short)((data[6] & 0xFF) << 8 | data[7] & 0xFF);
        this.expV = data[8];
        this.expH = data[9];
        this.vRes = (float)((double)(this.numV & 0xFFFF) * Math.pow(10.0, this.expV) / (double)(this.denomV & 0xFFFF));
        this.hRes = (float)((double)(this.numH & 0xFFFF) * Math.pow(10.0, this.expH) / (double)(this.denomH & 0xFFFF));
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return new ResolutionBoxMetadataNode(this);
    }

    @Override
    protected synchronized byte[] compose() {
        if (this.localData != null) {
            return this.localData;
        }
        this.localData = new byte[10];
        this.localData[0] = (byte)(this.numV >> 8);
        this.localData[1] = (byte)(this.numV & 0xFF);
        this.localData[2] = (byte)(this.denomV >> 8);
        this.localData[3] = (byte)(this.denomV & 0xFF);
        this.localData[4] = (byte)(this.numH >> 8);
        this.localData[5] = (byte)(this.numH & 0xFF);
        this.localData[6] = (byte)(this.denomH >> 8);
        this.localData[7] = (byte)(this.denomH & 0xFF);
        this.localData[8] = this.expV;
        this.localData[9] = this.expH;
        return this.localData;
    }

    public short getVerticalResolutionNumerator() {
        return this.numV;
    }

    public short getHorizontalResolutionNumerator() {
        return this.numH;
    }

    public short getVerticalResolutionDenominator() {
        return this.denomV;
    }

    public short getHorizontalResolutionDenominator() {
        return this.denomH;
    }

    public byte getVerticalResolutionExponent() {
        return this.expV;
    }

    public byte getHorizontalResolutionExponent() {
        return this.expH;
    }
}

