/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.PaletteBox;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import javax.imageio.metadata.IIOMetadataNode;

public class PaletteBoxMetadataNode
extends BaseJP2KBoxMetadataNode {
    private int numC;
    private int numE;
    private String numEntries;
    private String numComps;
    private String[] bitDepth;
    private byte[][] lut;

    public PaletteBoxMetadataNode(PaletteBox box) {
        super(box);
        byte[] bd = box.getBitDepths();
        byte[][] lookupt = box.getLUT();
        this.numC = box.getNumComp();
        this.numE = box.getNumEntries();
        this.bitDepth = new String[this.numC];
        this.lut = (byte[][])lookupt.clone();
        IIOMetadataNode child = new IIOMetadataNode("NumberEntries");
        child.setUserObject(new Integer(this.numE));
        this.numEntries = Integer.toString(this.numE);
        child.setNodeValue(this.numEntries);
        this.appendChild(child);
        child = new IIOMetadataNode("NumberColors");
        child.setUserObject(new Integer(this.numC));
        this.numComps = Integer.toString(this.numC);
        child.setNodeValue(this.numComps);
        this.appendChild(child);
        child = new IIOMetadataNode("BitDepth");
        child.setUserObject(bd.clone());
        child.setNodeValue(ImageIOUtilities.convertObjectToString((Object)bd));
        this.appendChild(child);
        child = new IIOMetadataNode("LUT");
        for (int i = 0; i < this.numE; ++i) {
            IIOMetadataNode child1 = new IIOMetadataNode("LUTRow");
            byte[] row = new byte[this.numC];
            for (int j = 0; j < this.numC; ++j) {
                row[j] = this.lut[j][i];
            }
            child1.setUserObject(row);
            child1.setNodeValue(ImageIOUtilities.convertObjectToString((Object)row));
            child.appendChild(child1);
        }
        this.appendChild(child);
    }

    public String getNumEntries() {
        return this.numEntries;
    }

    public String getNumComp() {
        return this.numComps;
    }

    public String getBitDepths(int index) {
        if (index > this.numC - 1) {
            throw new IllegalArgumentException("Number of BitDepth is " + this.numC);
        }
        return new String(this.bitDepth[index]);
    }

    public byte[][] getRawLUT() {
        return (byte[][])this.lut.clone();
    }
}

