/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.ndplugin.BaseImageMetadata;
import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class NetCDFImageMetadata
extends BaseImageMetadata {
    private static final String driverName = "netCDF";
    private static final String driverDescription = "Network Common Data Format";
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_nectdf_netcdfImageMetadata_1.0";
    private HashMap<String, String> additionalMetadata;
    private IIOMetadataNode nativeTree;

    protected NetCDFImageMetadata(BaseImageReader reader, int imageIndex) {
        super(reader, imageIndex);
    }

    protected void setMembers(BaseImageReader imageReader) throws IOException {
        super.setMembers(imageReader);
        if (imageReader instanceof NetCDFImageReader) {
            double[] validRange;
            double fillValue;
            double offset;
            int imageIndex = this.getImageIndex();
            NetCDFImageReader reader = (NetCDFImageReader)imageReader;
            this.setDriverName(driverName);
            this.setDriverDescription(driverDescription);
            this.setDatasetName(reader.getInnerReader().getVariableName(imageIndex));
            double scale = reader.getScale(imageIndex);
            if (!Double.isNaN(scale)) {
                this.setScales(new Double[]{scale});
            }
            if (!Double.isNaN(offset = reader.getOffset(imageIndex))) {
                this.setOffsets(new Double[]{offset});
            }
            if (!Double.isNaN(fillValue = reader.getFillValue(imageIndex))) {
                this.setNoDataValues(new Double[]{fillValue});
            }
            if ((validRange = reader.getValidRange(imageIndex)) != null && validRange.length == 2 && !Double.isNaN(validRange[0]) && !Double.isNaN(validRange[1])) {
                this.setMinimums(new Double[]{validRange[0]});
                this.setMaximums(new Double[]{validRange[1]});
            }
            this.setNumOverviews(new int[]{0});
            BaseNetCDFImageReader innerReader = reader.getInnerReader();
            int numAttributes = innerReader.getNumAttributes(imageIndex);
            this.additionalMetadata = new HashMap(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                NetCDFUtilities.KeyValuePair attributePair = innerReader.getAttribute(imageIndex, i);
                String attributeName = attributePair.getKey();
                String attributeValue = attributePair.getValue();
                this.additionalMetadata.put(attributeName, attributeValue);
            }
        } else {
            throw new IllegalArgumentException("Reader is not a NetCDFImageReader.");
        }
    }

    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createNativeTree();
        }
        if ("it_geosolutions_imageio_core_commonImageMetadata_1.0".equalsIgnoreCase(formatName)) {
            return super.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    private synchronized Node createNativeTree() {
        if (this.nativeTree != null) {
            return this.nativeTree;
        }
        this.nativeTree = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.additionalMetadata != null) {
            IIOMetadataNode node = new IIOMetadataNode("Attributes");
            for (String key : this.additionalMetadata.keySet()) {
                String attributeValue = this.additionalMetadata.get(key);
                node.setAttribute(key, attributeValue);
            }
            this.nativeTree.appendChild(node);
        }
        return this.nativeTree;
    }
}

