/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import it.geosolutions.imageio.plugins.nitronitf.ImageIOUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import nitf.DownSampler;
import nitf.IOHandle;
import nitf.IOInterface;
import nitf.ImageSubheader;
import nitf.NITFException;
import nitf.PixelSkipDownSampler;
import nitf.Reader;
import nitf.Record;
import nitf.SubWindow;

public class NITFReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.nitronitf.NITFReader");
    private IOHandle handle = null;
    private Reader reader = null;
    private Record record = null;
    private Map<Integer, nitf.ImageReader> imageReaderMap = Collections.synchronizedMap(new HashMap());

    public Reader getReader() {
        return this.reader;
    }

    public NITFReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input) {
        if (input instanceof File) {
            File file = (File)input;
            try {
                this.handle = new IOHandle(file.getAbsolutePath());
            }
            catch (NITFException e) {
                throw new IllegalArgumentException("Invalid file: " + file.getAbsolutePath(), e);
            }
        } else {
            throw new IllegalArgumentException("Currently, the input must be a File");
        }
    }

    public synchronized void readHeader() throws IOException {
        if (this.reader != null) {
            return;
        }
        if (this.handle == null) {
            throw new IllegalStateException("No input handle");
        }
        try {
            this.reader = new Reader();
            this.record = this.reader.read((IOInterface)this.handle);
        }
        catch (NITFException e) {
            LOGGER.severe(e.getLocalizedMessage());
            throw new IIOException("NITF Exception", e);
        }
    }

    private void checkIndex(int imageIndex) throws IOException {
        this.readHeader();
        int numImages = this.getNumImages(true);
        if (imageIndex < 0 || imageIndex >= numImages) {
            throw new IndexOutOfBoundsException("bad index: " + imageIndex);
        }
    }

    private synchronized nitf.ImageReader getImageReader(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        Integer key = new Integer(imageIndex);
        try {
            if (!this.imageReaderMap.containsKey(key)) {
                this.imageReaderMap.put(key, this.reader.getNewImageReader(imageIndex));
            }
            return this.imageReaderMap.get(key);
        }
        catch (NITFException e) {
            LOGGER.severe(e.getLocalizedMessage());
            throw new IIOException("NITF Exception", e);
        }
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.readHeader();
        try {
            return this.record.getHeader().getNumImages().getIntData();
        }
        catch (NITFException e) {
            LOGGER.severe(e.getLocalizedMessage());
            throw new IIOException("NITF Exception", e);
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        try {
            return this.record.getImages()[imageIndex].getSubheader().getNumCols().getIntData();
        }
        catch (NITFException e) {
            LOGGER.severe(e.getLocalizedMessage());
            throw new IIOException("NITF Exception", e);
        }
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        try {
            return this.record.getImages()[imageIndex].getSubheader().getNumRows().getIntData();
        }
        catch (NITFException e) {
            LOGGER.severe(e.getLocalizedMessage());
            throw new IIOException("NITF Exception", e);
        }
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        try {
            ImageSubheader subheader = this.record.getImages()[imageIndex].getSubheader();
            String irep = subheader.getImageRepresentation().getStringData().trim();
            String pvType = subheader.getPixelValueType().getStringData().trim();
            int bandCount = subheader.getBandCount();
            int nbpp = subheader.getNumBitsPerPixel().getIntData();
            int nBytes = (nbpp - 1) / 8 + 1;
            if (nBytes == 1 || nBytes == 2 || nBytes == 4 && pvType.equals("R") || nBytes == 8 && pvType.equals("R")) {
                if (nBytes == 1 && bandCount == 3 && irep.equals("RGB")) {
                    ColorSpace rgb = ColorSpace.getInstance(1000);
                    int[] bandOffsets = new int[3];
                    for (int i = 0; i < bandOffsets.length; ++i) {
                        bandOffsets[i] = i;
                    }
                    l.add(ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, 0, false, false));
                }
            } else {
                throw new UnsupportedOperationException("Support for pixels of size " + nbpp + " bytes has not been implemented yet");
            }
            l.add(ImageTypeSpecifier.createGrayscale(8, 0, false));
        }
        catch (NITFException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        int i;
        int[] sourceBands;
        ImageSubheader subheader;
        this.checkIndex(imageIndex);
        Rectangle sourceRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        NITFReader.computeRegions(param, this.getWidth(imageIndex), this.getHeight(imageIndex), null, sourceRegion, destRegion);
        int sourceXSubsampling = param != null ? param.getSourceXSubsampling() : 1;
        int sourceYSubsampling = param != null ? param.getSourceYSubsampling() : 1;
        Point destinationOffset = param != null ? param.getDestinationOffset() : new Point(0, 0);
        try {
            subheader = this.record.getImages()[imageIndex].getSubheader();
        }
        catch (NITFException e) {
            throw new IOException(e);
        }
        String irep = subheader.getImageRepresentation().getStringData().trim();
        String pvType = subheader.getPixelValueType().getStringData().trim();
        int nbpp = subheader.getNumBitsPerPixel().getIntData();
        int bandCount = subheader.getBandCount();
        int[] bandOffsets = null;
        int[] nArray = sourceBands = param != null ? param.getSourceBands() : null;
        if (param != null && param.getDestinationBands() != null) {
            bandOffsets = param.getDestinationBands();
        } else if (param != null && sourceBands != null) {
            bandOffsets = new int[sourceBands.length];
            for (i = 0; i < bandOffsets.length; ++i) {
                bandOffsets[i] = sourceBands[i];
            }
        } else {
            bandOffsets = new int[bandCount];
            for (i = 0; i < bandOffsets.length; ++i) {
                bandOffsets[i] = i;
            }
        }
        int nBytes = (nbpp - 1) / 8 + 1;
        int bufType = -1;
        if (nBytes == 1) {
            bufType = 0;
        } else if (nBytes == 2) {
            bufType = 1;
        } else if (nBytes == 4 && pvType.equals("R")) {
            bufType = 4;
        } else if (nBytes == 8 && pvType.equals("R")) {
            bufType = 5;
        } else {
            throw new UnsupportedOperationException("not yet implemented");
        }
        WritableRaster ras = ImageIOUtils.makeGenericPixelInterleavedWritableRaster(destRegion.width, destRegion.height, bandOffsets.length, bufType);
        NITFReader.checkReadParamBandSettings(param, bandCount, ras.getSampleModel().getNumBands());
        this.readRaster(imageIndex, sourceRegion, destRegion, sourceXSubsampling, sourceYSubsampling, bandOffsets, nBytes, destinationOffset, ras);
        return ras;
    }

    protected void readFullImage(int imageIndex, Rectangle destRegion, int sourceXSubsampling, int sourceYSubsampling, int[] bandOffsets, int pixelSize, WritableRaster imRas) throws IOException {
        try {
            ImageSubheader subheader = this.record.getImages()[imageIndex].getSubheader();
            int numCols = destRegion.width;
            int numRows = destRegion.height;
            int nBands = subheader.getBandCount();
            int[] requestBands = bandOffsets;
            int bufSize = numCols * numRows * pixelSize;
            byte[][] imageBuf = new byte[requestBands.length][bufSize];
            SubWindow window = new SubWindow();
            window.setNumBands(requestBands.length);
            window.setBandList(requestBands);
            window.setNumCols(numCols);
            window.setNumRows(numRows);
            window.setStartCol(0);
            window.setStartRow(0);
            if (sourceYSubsampling != 1 || sourceXSubsampling != 1) {
                PixelSkipDownSampler downSampler = new PixelSkipDownSampler(sourceYSubsampling, sourceXSubsampling);
                window.setDownSampler((DownSampler)downSampler);
            }
            nitf.ImageReader imageReader = this.getImageReader(imageIndex);
            imageReader.read(window, imageBuf);
            ArrayList<ByteBuffer> bandBufs = new ArrayList<ByteBuffer>();
            for (int i = 0; i < bandOffsets.length; ++i) {
                ByteBuffer bandBuf = null;
                bandBuf = bandOffsets.length != requestBands.length ? ByteBuffer.wrap(imageBuf[bandOffsets[i]]) : ByteBuffer.wrap(imageBuf[i]);
                bandBufs.add(bandBuf);
            }
            if (bandOffsets.length == 1) {
                ByteBuffer bandBuf = (ByteBuffer)bandBufs.get(0);
                switch (pixelSize) {
                    case 1: {
                        ByteBuffer rasterByteBuf = ByteBuffer.wrap(((DataBufferByte)imRas.getDataBuffer()).getData());
                        rasterByteBuf.put(bandBuf);
                        break;
                    }
                    case 2: {
                        ShortBuffer rasterShortBuf = ShortBuffer.wrap(((DataBufferUShort)imRas.getDataBuffer()).getData());
                        rasterShortBuf.put(bandBuf.asShortBuffer());
                        break;
                    }
                    case 4: {
                        FloatBuffer rasterFloatBuf = FloatBuffer.wrap(((DataBufferFloat)imRas.getDataBuffer()).getData());
                        rasterFloatBuf.put(bandBuf.asFloatBuffer());
                        break;
                    }
                    case 8: {
                        DoubleBuffer rasterDoubleBuf = DoubleBuffer.wrap(((DataBufferDouble)imRas.getDataBuffer()).getData());
                        rasterDoubleBuf.put(bandBuf.asDoubleBuffer());
                    }
                }
            } else {
                int srcX = 0;
                for (int srcY = 0; srcY < numRows; ++srcY) {
                    for (int dstX = 0; dstX < numCols; ++dstX) {
                        block17: for (int i = 0; i < bandOffsets.length; ++i) {
                            ByteBuffer bandBuf = (ByteBuffer)bandBufs.get(i);
                            switch (pixelSize) {
                                case 1: {
                                    imRas.setSample(dstX, srcY, i, bandBuf.get(srcX));
                                    continue block17;
                                }
                                case 2: {
                                    imRas.setSample(dstX, srcY, i, bandBuf.getShort(srcX));
                                    continue block17;
                                }
                                case 4: {
                                    imRas.setSample(dstX, srcY, i, bandBuf.getFloat(srcX));
                                    continue block17;
                                }
                                case 8: {
                                    imRas.setSample(dstX, srcY, i, bandBuf.getDouble(srcX));
                                }
                            }
                        }
                        srcX += pixelSize;
                    }
                }
            }
        }
        catch (NITFException e1) {
            throw new IOException(e1);
        }
    }

    protected void readRaster(int imageIndex, Rectangle sourceRegion, Rectangle destRegion, int sourceXSubsampling, int sourceYSubsampling, int[] bandOffsets, int pixelSize, Point destinationOffset, WritableRaster imRas) throws IOException {
        this.checkIndex(imageIndex);
        try {
            ImageSubheader subheader = this.record.getImages()[imageIndex].getSubheader();
            int numCols = subheader.getNumCols().getIntData();
            int numRows = subheader.getNumRows().getIntData();
            if (destRegion.height * sourceYSubsampling == numRows && destRegion.width * sourceXSubsampling == numCols) {
                this.readFullImage(imageIndex, destRegion, sourceXSubsampling, sourceYSubsampling, bandOffsets, pixelSize, imRas);
                return;
            }
            int colBytes = destRegion.width * pixelSize;
            int dstMinX = imRas.getMinX();
            int dstMaxX = dstMinX + imRas.getWidth() - 1;
            int dstMinY = imRas.getMinY();
            int dstMaxY = dstMinY + imRas.getHeight() - 1;
            int nBands = subheader.getBandCount();
            int[] requestBands = new int[nBands];
            for (int i = 0; i < nBands; ++i) {
                requestBands[i] = i;
            }
            byte[][] rowBuf = new byte[requestBands.length][colBytes];
            SubWindow window = new SubWindow();
            window.setNumBands(requestBands.length);
            window.setBandList(requestBands);
            window.setNumCols(destRegion.width);
            window.setNumRows(1);
            window.setStartCol(sourceRegion.x);
            window.setStartRow(sourceRegion.y);
            if (sourceYSubsampling != 1 || sourceXSubsampling != 1) {
                PixelSkipDownSampler downSampler = new PixelSkipDownSampler(sourceYSubsampling, sourceXSubsampling);
                window.setDownSampler((DownSampler)downSampler);
            }
            ArrayList<ByteBuffer> bandBufs = new ArrayList<ByteBuffer>();
            for (int i = 0; i < requestBands.length; ++i) {
                ByteBuffer bandBuf = null;
                bandBuf = ByteBuffer.wrap(rowBuf[i]);
                bandBufs.add(bandBuf);
            }
            nitf.ImageReader imageReader = this.getImageReader(imageIndex);
            block12: for (int srcY = 0; srcY < sourceRegion.height; ++srcY) {
                if (sourceYSubsampling != 1 && srcY % sourceYSubsampling != 0) continue;
                window.setStartRow(sourceRegion.y + srcY);
                try {
                    imageReader.read(window, rowBuf);
                }
                catch (NITFException e) {
                    throw new IIOException("Error reading line " + srcY, e);
                }
                int dstY = destinationOffset.y + srcY / sourceYSubsampling;
                if (dstY < dstMinY) continue;
                if (dstY <= dstMaxY) {
                    int srcX = 0;
                    int dstX = destinationOffset.x;
                    while (srcX < colBytes) {
                        if (dstX >= dstMinX) {
                            if (dstX > dstMaxX) continue block12;
                            block14: for (int i = 0; i < bandOffsets.length; ++i) {
                                ByteBuffer bandBuf = (ByteBuffer)bandBufs.get(bandOffsets[i]);
                                switch (pixelSize) {
                                    case 1: {
                                        imRas.setSample(dstX, dstY, i, bandBuf.get(srcX));
                                        continue block14;
                                    }
                                    case 2: {
                                        imRas.setSample(dstX, dstY, i, bandBuf.getShort(srcX));
                                        continue block14;
                                    }
                                    case 4: {
                                        imRas.setSample(dstX, dstY, i, bandBuf.getFloat(srcX));
                                        continue block14;
                                    }
                                    case 8: {
                                        imRas.setSample(dstX, dstY, i, bandBuf.getDouble(srcX));
                                    }
                                }
                            }
                        }
                        srcX += pixelSize;
                        ++dstX;
                    }
                    continue;
                }
                break;
            }
        }
        catch (NITFException e1) {
            throw new IOException(e1);
        }
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readHeader();
        Raster raster = this.readRaster(imageIndex, param);
        int numDestBands = param != null ? (param.getDestinationBands() != null ? param.getDestinationBands().length : (param.getSourceBands() != null ? param.getSourceBands().length : 0)) : 0;
        ImageTypeSpecifier imageType = null;
        ImageTypeSpecifier firstType = null;
        Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
        while (imageTypes.hasNext() && imageType == null) {
            ImageTypeSpecifier currentImageType = imageTypes.next();
            if (firstType == null) {
                firstType = currentImageType;
            }
            if (currentImageType.getNumBands() != numDestBands) continue;
            imageType = currentImageType;
        }
        if (imageType == null) {
            if (firstType == null) {
                throw new IOException("Unable to determine the ImageTypeSpecifier");
            }
            imageType = firstType;
        }
        try {
            ImageSubheader subheader = this.record.getImages()[imageIndex].getSubheader();
            String pvType = subheader.getPixelValueType().getStringData().trim();
            int nbpp = subheader.getNumBitsPerPixel().getIntData();
            int nBytes = (nbpp - 1) / 8 + 1;
            if (nBytes == 1 || nBytes == 2 || nBytes == 4 && pvType.equals("R") || nBytes == 8 && pvType.equals("R")) {
                return ImageIOUtils.rasterToBufferedImage(raster, imageType);
            }
        }
        catch (NITFException e) {
            throw new IOException(e);
        }
        throw new UnsupportedOperationException("Image pixel type or bits per pixel not yet supported");
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    public Record getRecord() throws IOException {
        this.readHeader();
        return this.record;
    }
}

