/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;

public final class RasterByteGrayAlphaProvider
extends AbstractScanlineProvider {
    static final int[] PIXEL_STRIDES = new int[]{2};
    final byte[] bytes;
    boolean alphaFirst;
    int[] bandOffsets;
    int pixelStride;
    int numBands;

    public RasterByteGrayAlphaProvider(Raster raster) {
        super(raster, 8, raster.getWidth() * RasterByteGrayAlphaProvider.computePixelStride(raster, PIXEL_STRIDES), RasterByteGrayAlphaProvider.computePixelStride(raster, PIXEL_STRIDES));
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        this.bandOffsets = sm.getBandOffsets();
        this.numBands = sm.getNumBands();
        this.pixelStride = sm.getPixelStride();
        this.alphaFirst = this.bandOffsets[0] != 0;
    }

    @Override
    public void next(byte[] row, int offset, int length) {
        int bytesIdx = this.cursor.next();
        if (!this.alphaFirst && this.numBands == this.pixelStride) {
            System.arraycopy(this.bytes, bytesIdx, row, offset, length);
        } else {
            int max = offset + length;
            for (int i = offset; i < max; i += this.numBands) {
                for (int j = 0; j < this.numBands; ++j) {
                    row[i + j] = this.bytes[bytesIdx + this.bandOffsets[j]];
                }
                bytesIdx += this.pixelStride;
            }
        }
    }
}

