/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;

public final class RasterShortABGRProvider
extends AbstractScanlineProvider {
    final short[] shorts;
    final boolean bgrOrder;
    final boolean hasAlpha;

    public RasterShortABGRProvider(Raster raster, boolean hasAlpha) {
        super(raster, 16, (hasAlpha ? 8 : 6) * raster.getWidth(), hasAlpha ? 4 : 3);
        this.hasAlpha = hasAlpha;
        this.shorts = ((DataBufferUShort)raster.getDataBuffer()).getData();
        this.bgrOrder = ((ComponentSampleModel)raster.getSampleModel()).getBandOffsets()[0] != 0;
    }

    @Override
    public void next(byte[] scanline, int offset, int length) {
        int shortsIdx = this.cursor.next();
        int i = offset;
        int max = offset + length;
        if (this.hasAlpha) {
            if (this.bgrOrder) {
                while (i < max) {
                    short a = this.shorts[shortsIdx++];
                    short b = this.shorts[shortsIdx++];
                    short g = this.shorts[shortsIdx++];
                    short r = this.shorts[shortsIdx++];
                    scanline[i++] = (byte)(r >> 8 & 0xFF);
                    scanline[i++] = (byte)(r & 0xFF);
                    scanline[i++] = (byte)(g >> 8 & 0xFF);
                    scanline[i++] = (byte)(g & 0xFF);
                    scanline[i++] = (byte)(b >> 8 & 0xFF);
                    scanline[i++] = (byte)(b & 0xFF);
                    scanline[i++] = (byte)(a >> 8 & 0xFF);
                    scanline[i++] = (byte)(a & 0xFF);
                }
            } else {
                while (i < max) {
                    short r = this.shorts[shortsIdx++];
                    short g = this.shorts[shortsIdx++];
                    short b = this.shorts[shortsIdx++];
                    short a = this.shorts[shortsIdx++];
                    scanline[i++] = (byte)(r >> 8 & 0xFF);
                    scanline[i++] = (byte)(r & 0xFF);
                    scanline[i++] = (byte)(g >> 8 & 0xFF);
                    scanline[i++] = (byte)(g & 0xFF);
                    scanline[i++] = (byte)(b >> 8 & 0xFF);
                    scanline[i++] = (byte)(b & 0xFF);
                    scanline[i++] = (byte)(a >> 8 & 0xFF);
                    scanline[i++] = (byte)(a & 0xFF);
                }
            }
        } else if (this.bgrOrder) {
            while (i < max) {
                short b = this.shorts[shortsIdx++];
                short g = this.shorts[shortsIdx++];
                short r = this.shorts[shortsIdx++];
                scanline[i++] = (byte)(r >> 8 & 0xFF);
                scanline[i++] = (byte)(r & 0xFF);
                scanline[i++] = (byte)(g >> 8 & 0xFF);
                scanline[i++] = (byte)(g & 0xFF);
                scanline[i++] = (byte)(b >> 8 & 0xFF);
                scanline[i++] = (byte)(b & 0xFF);
            }
        } else {
            while (i < max) {
                short r = this.shorts[shortsIdx++];
                short g = this.shorts[shortsIdx++];
                short b = this.shorts[shortsIdx++];
                scanline[i++] = (byte)(r >> 8 & 0xFF);
                scanline[i++] = (byte)(r & 0xFF);
                scanline[i++] = (byte)(g >> 8 & 0xFF);
                scanline[i++] = (byte)(g & 0xFF);
                scanline[i++] = (byte)(b >> 8 & 0xFF);
                scanline[i++] = (byte)(b & 0xFF);
            }
        }
    }
}

