/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;

final class ScanlineCursor {
    final int scanlineStride;
    final int maxPosition;
    int position;

    public ScanlineCursor(Raster raster, int pixelStride) {
        this.scanlineStride = this.getScanlineStride(raster);
        this.position = raster.getDataBuffer().getOffset();
        this.maxPosition = raster.getDataBuffer().getSize();
        int rowTranslate = raster.getSampleModelTranslateY() * this.scanlineStride;
        this.position -= rowTranslate;
        int pixelTranslate = raster.getSampleModelTranslateX() * pixelStride;
        this.position -= pixelTranslate;
    }

    public int next() {
        int result = this.position;
        if (result >= this.maxPosition) {
            throw new IllegalStateException("We got past the end of the buffer, current position is " + this.position + " and max position value is " + this.maxPosition);
        }
        this.position += this.scanlineStride;
        return result;
    }

    int getScanlineStride(Raster raster) {
        if (raster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
            return csm.getScanlineStride();
        }
        if (raster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
            return sampleModel.getScanlineStride();
        }
        if (raster.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel sampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
            return sampleModel.getScanlineStride();
        }
        return raster.getDataBuffer().getSize() / raster.getHeight();
    }
}

