/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.exif;

import java.util.Arrays;

public class TIFFTagWrapper {
    private int number;
    private int count;
    private int type;
    private int value;
    private byte[] suffix;
    private byte[] prefix;
    private Object content;

    public String toString() {
        return "TIFFTagWrapper [content=" + this.content + ", value=" + this.value + ", count=" + this.count + ", prefix=" + Arrays.toString(this.prefix) + ", suffix=" + Arrays.toString(this.suffix) + ", type=" + this.type + ", number=" + this.number + "]";
    }

    public TIFFTagWrapper(int tagNumber, int type, String content, int value, int count) {
        this(tagNumber, type, content, value, count, null, null);
    }

    public TIFFTagWrapper(int tagNumber, int type, Object content, int valueOffset, int count, byte[] prefix, byte[] suffix) {
        this.count = count;
        this.number = tagNumber;
        this.type = type;
        this.prefix = prefix != null ? (byte[])prefix.clone() : null;
        byte[] byArray = this.suffix = suffix != null ? (byte[])suffix.clone() : null;
        if (content != null) {
            this.content = content;
            int n = this.count = content instanceof byte[] ? ((byte[])content).length : 0;
            if (suffix != null) {
                this.count += suffix.length;
            }
            if (prefix != null) {
                this.count += prefix.length;
            }
        }
        this.value = valueOffset;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    public void setPrefix(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getSuffix() {
        return this.suffix;
    }

    public void setSuffix(byte[] suffix) {
        this.suffix = suffix;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }
}

