/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import java.util.logging.Level;
import java.util.logging.Logger;

public class TurboJpegUtilities {
    private static final Logger LOGGER = Logger.getLogger(TurboJpegUtilities.class.getName());
    public static final String FLAGS_PROPERTY = "it.geosolutions.imageio.plugins.turbojpeg.flags";
    private static boolean isAvailable;
    private static boolean isInitialized;
    public static final String LIBNAME = "turbojpeg";

    public static boolean isTurboJpegAvailable() {
        TurboJpegUtilities.loadTurboJpeg();
        return isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTurboJpeg() {
        if (isInitialized) {
            return;
        }
        Logger logger = LOGGER;
        synchronized (logger) {
            if (isInitialized) {
                return;
            }
            try {
                TurboJpegUtilities.load();
                isAvailable = true;
            }
            catch (Throwable t) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Failed to load the TurboJpeg native libs. This is not a problem, but the TurboJpeg encoder won't be available: " + t.toString());
                }
            }
            finally {
                isInitialized = true;
            }
        }
    }

    static void load() {
        try {
            System.loadLibrary(LIBNAME);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("TurboJPEG library loaded (turbojpeg)");
            }
        }
        catch (UnsatisfiedLinkError e) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("mac") >= 0) {
                System.load("/usr/lib/libturbojpeg.jnilib");
            }
            throw e;
        }
    }

    public static int getTurboJpegFlag(String key) {
        if (key != null) {
            if (key.equalsIgnoreCase("FLAG_ACCURATEDCT")) {
                return 4096;
            }
            if (key.equalsIgnoreCase("FLAG_BOTTOMUP")) {
                return 2;
            }
            if (key.equalsIgnoreCase("FLAG_FASTDCT")) {
                return 2048;
            }
            if (key.equalsIgnoreCase("FLAG_FASTUPSAMPLE")) {
                return 256;
            }
            if (key.equalsIgnoreCase("FLAG_FORCEMMX")) {
                return 8;
            }
            if (key.equalsIgnoreCase("FLAG_FORCESSE")) {
                return 16;
            }
            if (key.equalsIgnoreCase("FLAG_FORCESSE2")) {
                return 32;
            }
            if (key.equalsIgnoreCase("FLAG_FORCESSE3")) {
                return 128;
            }
        }
        throw new IllegalArgumentException("Unsupported flag");
    }

    public static String getTurboJpegFlagAsString(int key) {
        switch (key) {
            case 4096: {
                return "FLAG_ACCURATEDCT";
            }
            case 2: {
                return "FLAG_BOTTOMUP";
            }
            case 2048: {
                return "FLAG_FASTDCT";
            }
            case 256: {
                return "FLAG_FASTUPSAMPLE";
            }
            case 8: {
                return "FLAG_FORCEMMX";
            }
            case 16: {
                return "FLAG_FORCESSE";
            }
            case 32: {
                return "FLAG_FORCESSE2";
            }
            case 128: {
                return "FLAG_FORCESSE3";
            }
        }
        throw new IllegalArgumentException("Unsupported flag");
    }

    static {
        isInitialized = false;
    }
}

