/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.exif;

import it.geosolutions.imageio.plugins.exif.EXIFTags;
import it.geosolutions.imageio.plugins.exif.TIFFTagWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EXIFMetadata {
    Map<EXIFTags.Type, List<TIFFTagWrapper>> tags;

    public EXIFMetadata(List<TIFFTagWrapper> baselineExifTags, List<TIFFTagWrapper> exifTags) {
        this.tags = new HashMap<EXIFTags.Type, List<TIFFTagWrapper>>();
        this.tags.put(EXIFTags.Type.BASELINE, baselineExifTags);
        this.tags.put(EXIFTags.Type.EXIF, exifTags);
    }

    public EXIFMetadata(Map<EXIFTags.Type, List<TIFFTagWrapper>> tagsMap) {
        this.tags = tagsMap;
    }

    public void setTag(int tagNumber, Object content, EXIFTags.Type tagType) {
        List<TIFFTagWrapper> list = this.getList(tagType);
        for (TIFFTagWrapper wrapper : list) {
            if (wrapper.getNumber() != tagNumber) continue;
            wrapper.setContent(content);
            if (!(content instanceof byte[])) break;
            int count = ((byte[])content).length;
            if (wrapper.getSuffix() != null) {
                count += wrapper.getSuffix().length;
            }
            if (wrapper.getPrefix() != null) {
                count += wrapper.getPrefix().length;
            }
            wrapper.setCount(count);
            break;
        }
    }

    List<TIFFTagWrapper> getList(EXIFTags.Type tagType) {
        switch (tagType) {
            case EXIF: {
                return this.tags.get((Object)EXIFTags.Type.EXIF);
            }
            case BASELINE: {
                return this.tags.get((Object)EXIFTags.Type.BASELINE);
            }
        }
        return null;
    }
}

