/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.vecmath.GMatrix;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.iterator.RandomIterFactory;
import org.eclipse.imagen.iterator.WritableRandomIter;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class NetCDFCFExperiment {
    private float xmin = Float.NaN;
    private float ymin = Float.NaN;
    private float xmax = Float.NaN;
    private float ymax = Float.NaN;
    private float periodX = Float.NaN;
    private float periodY = Float.NaN;
    private static final ArrayList<String> variables = new ArrayList(7);
    static final int NUMVARS;
    static final String UNITS = "units";
    private static final boolean APPLY_MASK = true;
    public static int JGREG;
    public static double HALFSECOND;

    public static void main(String[] args) {
        NetCDFCFExperiment o = new NetCDFCFExperiment();
        String fileNameOut = "c:/tmp/netcdf.nc";
        String fileNameIn = "c:/original.nc";
        o.run(fileNameIn, fileNameOut);
    }

    private void run(String fileNameIn, String fileNameOut) {
        try {
            NetcdfFile ncFileIn = NetcdfFile.open((String)fileNameIn);
            ncFileIn.writeCDL((OutputStream)System.out, true);
            NetcdfFileWriteable ncFileOut = NetcdfFileWriteable.createNew((String)fileNameOut);
            Dimension timeDim0 = ncFileIn.findDimension("time");
            Dimension latDim0 = ncFileIn.findDimension("lat");
            Dimension lonDim0 = ncFileIn.findDimension("lon");
            Variable time_0 = ncFileIn.findVariable("time");
            Array time_0_Data = time_0.read();
            Index time_0_Index = time_0_Data.getIndex();
            Variable grid3 = ncFileIn.findVariable("grid3");
            int nLat = grid3.getDimension(0).getLength();
            int nLon = grid3.getDimension(1).getLength();
            String units = grid3.findAttribute(UNITS).getStringValue();
            String[] unit = units.split(",");
            Array lat_0_Data = grid3.read("0:" + (nLat - 1) + ":1, 0:0:1, 1:1:1").reduce();
            Index lat_0_Index = lat_0_Data.getIndex();
            Array lon_0_Data = grid3.read("0:0:1, 0:" + (nLon - 1) + ":1, 0:0:1").reduce();
            Index lon_0_Index = lon_0_Data.getIndex();
            Variable z_0 = ncFileIn.findVariable("zout");
            int nLevels = z_0.getDimension(0).getLength();
            Array z_0_Data = z_0.read("0:" + (nLevels - 1) + ":1, 2:2:1");
            Dimension timeDim = ncFileOut.addDimension("time", timeDim0.getLength());
            Dimension latDim = ncFileOut.addDimension("lat", latDim0.getLength());
            Dimension lonDim = ncFileOut.addDimension("lon", lonDim0.getLength());
            Dimension depthDim = ncFileOut.addDimension("depth", nLevels);
            this.computeMatrixExtremes(lat_0_Data, lon_0_Data, lonDim0.getLength(), latDim0.getLength(), lat_0_Index, lon_0_Index);
            NetCDFCFExperiment.copyGlobalAttributes(ncFileOut, ncFileIn.getGlobalAttributes());
            ncFileOut.addVariable("time", DataType.FLOAT, new Dimension[]{timeDim});
            float referenceTime = this.setTimeVariableAttributes(time_0, ncFileOut);
            ArrayFloat lat_1_Data = new ArrayFloat(new int[]{latDim0.getLength()});
            Index lat_1_Index = lat_1_Data.getIndex();
            ncFileOut.addVariable("lat", DataType.FLOAT, new Dimension[]{latDim});
            ncFileOut.addVariableAttribute("lat", "long_name", "latitude");
            ncFileOut.addVariableAttribute("lat", UNITS, unit[1].trim());
            for (int yPos = 0; yPos < latDim0.getLength(); ++yPos) {
                lat_1_Data.setFloat(lat_1_Index.set(yPos), new Float(this.ymax - new Float(yPos).floatValue() * this.periodY).floatValue());
            }
            ArrayFloat lon_1_Data = new ArrayFloat(new int[]{lonDim0.getLength()});
            Index lon_1_Index = lon_1_Data.getIndex();
            ncFileOut.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDim});
            ncFileOut.addVariableAttribute("lon", "long_name", "longitude");
            ncFileOut.addVariableAttribute("lon", UNITS, unit[0].trim());
            for (int xPos = 0; xPos < lonDim0.getLength(); ++xPos) {
                lon_1_Data.setFloat(lon_1_Index.set(xPos), new Float(this.xmin + new Float(xPos).floatValue() * this.periodX).floatValue());
            }
            ArrayInt depthlevelDim_1_Data = new ArrayInt(new int[]{depthDim.getLength()});
            Index depthlevelDim_1_Index = depthlevelDim_1_Data.getIndex();
            ncFileOut.addVariable("depth", DataType.FLOAT, new Dimension[]{depthDim});
            ncFileOut.addVariableAttribute("depth", "long_name", "depth");
            ncFileOut.addVariableAttribute("depth", UNITS, unit[2].trim());
            ncFileOut.addVariableAttribute("depth", "positive", "up");
            for (int wPos = 0; wPos < depthDim.getLength(); ++wPos) {
                depthlevelDim_1_Data.setFloat(depthlevelDim_1_Index.set(wPos), z_0_Data.getFloat(depthlevelDim_1_Index));
            }
            for (int i = 0; i < NUMVARS; ++i) {
                String varName = variables.get(i);
                Variable var = ncFileIn.findVariable(varName);
                ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, depthDim, latDim, lonDim});
                NetCDFCFExperiment.setVariableAttributes(var, ncFileOut, new String[]{"positions"});
            }
            ncFileOut.create();
            ArrayFloat timeData = new ArrayFloat(new int[]{timeDim.getLength()});
            Index timeIndex = timeData.getIndex();
            for (int t = 0; t < timeDim.getLength(); ++t) {
                float julianTime = time_0_Data.getFloat(time_0_Index.set(t)) - referenceTime;
                timeData.setFloat(timeIndex.set(t), julianTime);
            }
            ncFileOut.write("time", (Array)timeData);
            Variable timeVar = ncFileOut.findVariable("time");
            timeDim.addCoordinateVariable(timeVar);
            ncFileOut.write("lat", (Array)lat_1_Data);
            ncFileOut.write("lon", (Array)lon_1_Data);
            Variable depthVar = ncFileOut.findVariable("depth");
            depthDim.addCoordinateVariable(depthVar);
            ncFileOut.write("depth", (Array)depthlevelDim_1_Data);
            ArrayFloat.D2 maskMatrix = new ArrayFloat.D2(latDim.getLength(), lonDim.getLength());
            Index maskIma = maskMatrix.getIndex();
            Variable mask = ncFileIn.findVariable("mask");
            Array maskData = mask.read();
            Index maskIndex = maskData.getIndex();
            ArrayFloat tempData = new ArrayFloat(new int[]{latDim0.getLength(), lonDim0.getLength()});
            Index tempIndex = tempData.getIndex();
            for (int yPos = 0; yPos < latDim0.getLength(); ++yPos) {
                for (int xPos = 0; xPos < lonDim0.getLength(); ++xPos) {
                    tempData.setFloat(tempIndex.set(yPos, xPos), maskData.getFloat(maskIndex.set(yPos, xPos)));
                }
            }
            WritableRaster outData = this.Resampler(lat_0_Data, lon_0_Data, lonDim0.getLength(), latDim0.getLength(), 2, (Array)tempData, -1.0f);
            for (int j = 0; j < latDim0.getLength(); ++j) {
                for (int k = 0; k < lonDim0.getLength(); ++k) {
                    float sample = outData.getSampleFloat(k, j, 0);
                    maskMatrix.setFloat(maskIma.set(j, k), sample);
                }
            }
            for (int i = 0; i < NUMVARS; ++i) {
                String varName = variables.get(i);
                Variable var = ncFileIn.findVariable(varName);
                Array originalVarData = var.read();
                Index varIndex = originalVarData.getIndex();
                Attribute fv = var.findAttribute("_FillValue");
                float fillValue = Float.NaN;
                if (fv != null) {
                    fillValue = fv.getNumericValue().floatValue();
                }
                ArrayFloat T_tmp_Data = new ArrayFloat(new int[]{latDim0.getLength(), lonDim0.getLength()});
                Index T_tmp_Index = T_tmp_Data.getIndex();
                ArrayFloat.D4 Tmatrix = new ArrayFloat.D4(timeDim.getLength(), depthDim.getLength(), latDim.getLength(), lonDim.getLength());
                Index Tima = Tmatrix.getIndex();
                for (int tPos = 0; tPos < timeDim0.getLength(); ++tPos) {
                    for (int levelPos = 0; levelPos < depthDim.getLength(); ++levelPos) {
                        for (int yPos = 0; yPos < latDim0.getLength(); ++yPos) {
                            for (int xPos = 0; xPos < lonDim0.getLength(); ++xPos) {
                                T_tmp_Data.setFloat(T_tmp_Index.set(yPos, xPos), originalVarData.getFloat(varIndex.set(tPos, yPos, xPos, levelPos)));
                            }
                        }
                        WritableRaster outData2 = this.Resampler(lat_0_Data, lon_0_Data, lonDim0.getLength(), latDim0.getLength(), 2, (Array)T_tmp_Data, fillValue);
                        for (int j = 0; j < latDim0.getLength(); ++j) {
                            for (int k = 0; k < lonDim0.getLength(); ++k) {
                                float sample = outData2.getSampleFloat(k, j, 0);
                                float maskValue = maskMatrix.getFloat(maskIma.set(j, k));
                                if (maskValue == 0.0f) {
                                    sample = fillValue;
                                }
                                Tmatrix.setFloat(Tima.set(tPos, levelPos, j, k), sample);
                            }
                        }
                    }
                }
                ncFileOut.write(varName, (Array)Tmatrix);
            }
            ncFileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private float setTimeVariableAttributes(Variable time_0, NetcdfFileWriteable ncFileOut) throws IOException {
        Object second;
        Object minute;
        float referenceTime;
        Array time_0_Data = time_0.read();
        Index time_0_Index = time_0_Data.getIndex();
        String name = time_0.getName();
        float fTime = referenceTime = time_0_Data.getFloat(time_0_Index.set(0));
        Attribute offset = time_0.findAttribute("add_offset");
        if (offset != null) {
            fTime += offset.getNumericValue().floatValue();
        }
        GregorianCalendar calendar = NetCDFCFExperiment.fromJulian(fTime);
        String year = Integer.toString(calendar.get(1));
        String month = Integer.toString(calendar.get(2) + 1);
        String day = Integer.toString(calendar.get(5));
        Object hour = Integer.toString(calendar.get(10));
        if (((String)hour).equalsIgnoreCase("0")) {
            hour = (String)hour + "0";
        }
        if (((String)(minute = Integer.toString(calendar.get(12)))).equalsIgnoreCase("0")) {
            minute = (String)minute + "0";
        }
        if (((String)(second = Integer.toString(calendar.get(13)))).equalsIgnoreCase("0")) {
            second = (String)second + "0";
        }
        String millisecond = Integer.toString(calendar.get(14));
        StringBuffer sbTime = new StringBuffer(year).append("-").append(month).append("-").append(day).append(" ").append((String)hour).append(":").append((String)minute).append(":").append((String)second).append(".").append(millisecond);
        ncFileOut.addVariableAttribute(name, UNITS, "days since " + sbTime.toString());
        ncFileOut.addVariableAttribute(name, "long_name", "time");
        return referenceTime;
    }

    private WritableRaster Resampler(Array latData, Array lonData, int imageWidth, int imageHeight, int polyDegree, Array data, float fillValue) {
        Index latIndex = latData.getIndex();
        Index lonIndex = lonData.getIndex();
        int numCoeffs = (polyDegree + 1) * (polyDegree + 2) / 2;
        boolean XOFFSET = false;
        boolean YOFFSET = true;
        int stepX = 2;
        int stepY = 2;
        int numNeededPoints = 0;
        for (int xi = 0; xi < imageWidth; xi += 2) {
            for (int yi = 0; yi < imageHeight; yi += 2) {
                ++numNeededPoints;
            }
        }
        this.computeMatrixExtremes(latData, lonData, imageWidth, imageHeight, latIndex, lonIndex);
        float[] destCoords = new float[2 * numNeededPoints];
        float[] srcCoords = new float[2 * numNeededPoints];
        int offset = 0;
        for (int yi = 0; yi < imageHeight; yi += 2) {
            for (int xi = 0; xi < imageWidth; xi += 2) {
                srcCoords[offset] = xi;
                srcCoords[offset + 1] = yi;
                destCoords[offset] = (lonData.getFloat(lonIndex.set(xi)) - this.xmin) / this.periodX;
                destCoords[offset + 1] = (this.ymax - latData.getFloat(latIndex.set(yi))) / this.periodY;
                offset += 2;
            }
        }
        GMatrix A = new GMatrix(numNeededPoints, numCoeffs);
        for (int coord = 0; coord < numNeededPoints; ++coord) {
            int var = 0;
            for (int i = 0; i <= polyDegree; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double value = Math.pow(destCoords[2 * coord + 0], i - j) * Math.pow(destCoords[2 * coord + 1], j);
                    A.setElement(coord, var++, value);
                }
            }
        }
        GMatrix AtAi = new GMatrix(numCoeffs, numCoeffs);
        GMatrix Ap = new GMatrix(numCoeffs, numNeededPoints);
        AtAi.mulTransposeLeft(A, A);
        AtAi.invert();
        Ap.mulTransposeRight(AtAi, A);
        GMatrix xVector = new GMatrix(numNeededPoints, 1);
        GMatrix yVector = new GMatrix(numNeededPoints, 1);
        for (int idx = 0; idx < numNeededPoints; ++idx) {
            xVector.setElement(idx, 0, (double)srcCoords[2 * idx + 0]);
            yVector.setElement(idx, 0, (double)srcCoords[2 * idx + 1]);
        }
        GMatrix xCoeffsG = new GMatrix(numCoeffs, 1);
        GMatrix yCoeffsG = new GMatrix(numCoeffs, 1);
        xCoeffsG.mul(Ap, xVector);
        yCoeffsG.mul(Ap, yVector);
        float[] xCoeffs = new float[numCoeffs];
        float[] yCoeffs = new float[numCoeffs];
        for (int ii = 0; ii < numCoeffs; ++ii) {
            xCoeffs[ii] = new Double(xCoeffsG.getElement(ii, 0)).floatValue();
            yCoeffs[ii] = new Double(yCoeffsG.getElement(ii, 0)).floatValue();
        }
        SampleModel outSampleModel = RasterFactory.createBandedSampleModel((int)4, (int)imageWidth, (int)imageHeight, (int)1);
        WritableRaster outDataCube = Raster.createWritableRaster(outSampleModel, null);
        WritableRandomIter iteratorDataCube = RandomIterFactory.createWritable((WritableRaster)outDataCube, null);
        Index indexInputVar = data.getIndex();
        for (int jj = 0; jj < outDataCube.getNumBands(); ++jj) {
            for (int kk = 0; kk < outDataCube.getWidth(); ++kk) {
                for (int ll = 0; ll < outDataCube.getHeight(); ++ll) {
                    iteratorDataCube.setSample(kk, ll, jj, data.getFloat(indexInputVar.set(ll, kk)));
                }
            }
        }
        WritableRaster target = RasterFactory.createWritableRaster((SampleModel)outSampleModel, null);
        for (int bi = 0; bi < outDataCube.getNumBands(); ++bi) {
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    float[] dstCoords = new float[2];
                    GMatrix regressionVec = new GMatrix(numCoeffs, 1);
                    int var = 0;
                    for (int i = 0; i <= polyDegree; ++i) {
                        for (int j = 0; j <= i; ++j) {
                            double value = Math.pow(xi, i - j) * Math.pow(yi, j);
                            regressionVec.setElement(var++, 0, value);
                        }
                    }
                    GMatrix xG = new GMatrix(1, 1);
                    GMatrix yG = new GMatrix(1, 1);
                    xG.mulTransposeLeft(regressionVec, xCoeffsG);
                    yG.mulTransposeLeft(regressionVec, yCoeffsG);
                    int X = (int)Math.round(xG.getElement(0, 0));
                    int Y = (int)Math.round(yG.getElement(0, 0));
                    if (X >= 0 && Y >= 0 && X < imageWidth && Y < imageHeight) {
                        target.setSample(xi, yi, bi, outDataCube.getSampleFloat(X, Y, bi));
                        continue;
                    }
                    target.setSample(xi, yi, bi, fillValue);
                }
            }
        }
        return target;
    }

    private void computeMatrixExtremes(Array latData, Array lonData, int imageWidth, int imageHeight, Index latIndex, Index lonIndex) {
        if (Float.isNaN(this.xmin) || Float.isNaN(this.ymin) || Float.isNaN(this.xmax) || Float.isNaN(this.ymax) || Float.isNaN(this.periodX) || Float.isNaN(this.periodY)) {
            this.xmin = Float.POSITIVE_INFINITY;
            this.ymin = Float.POSITIVE_INFINITY;
            this.xmax = Float.NEGATIVE_INFINITY;
            this.ymax = Float.NEGATIVE_INFINITY;
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    float x = lonData.getFloat(lonIndex.set(xi));
                    float y = latData.getFloat(latIndex.set(yi));
                    if (x < this.xmin) {
                        this.xmin = x;
                    }
                    if (x > this.xmax) {
                        this.xmax = x;
                    }
                    if (y < this.ymin) {
                        this.ymin = y;
                    }
                    if (!(y > this.ymax)) continue;
                    this.ymax = y;
                }
            }
            float rangeX = this.xmax - this.xmin;
            float rangeY = this.ymax - this.ymin;
            this.periodX = rangeX / (float)(imageWidth - 1);
            this.periodY = rangeY / (float)(imageHeight - 1);
            System.out.println(this.xmin + ":" + this.ymin + " - " + this.xmax + ":" + this.ymax + " / " + this.periodX + ":" + this.periodY);
        }
    }

    private static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile, String[] exceptions) {
        List attributes = variable.getAttributes();
        String name = variable.getName();
        if (attributes != null) {
            for (Attribute att : attributes) {
                String attribName = att.getName();
                boolean skip = false;
                if (exceptions != null) {
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (!exceptions[i].equalsIgnoreCase(attribName)) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                if (att.isArray()) {
                    writableFile.addVariableAttribute(name, attribName, att.getValues());
                    continue;
                }
                if (att.isString()) {
                    writableFile.addVariableAttribute(name, attribName, att.getStringValue());
                    continue;
                }
                writableFile.addVariableAttribute(name, attribName, att.getNumericValue());
            }
        }
    }

    private static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile) {
        NetCDFCFExperiment.setVariableAttributes(variable, writableFile, null);
    }

    private static void copyGlobalAttributes(NetcdfFileWriteable writableFile, List<Attribute> attributes) {
        if (!attributes.isEmpty()) {
            for (Attribute attrib : attributes) {
                if (attrib.isArray()) {
                    writableFile.addGlobalAttribute(attrib.getName(), attrib.getValues());
                    continue;
                }
                if (attrib.isString()) {
                    writableFile.addGlobalAttribute(attrib.getName(), attrib.getStringValue());
                    continue;
                }
                writableFile.addGlobalAttribute(attrib.getName(), attrib.getNumericValue());
            }
        }
    }

    public static GregorianCalendar fromJulian(double injulian) {
        double julian = injulian + HALFSECOND / 86400.0;
        int ja = (int)injulian;
        if (ja >= JGREG) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        return new GregorianCalendar(year, month - 1, day);
    }

    static {
        variables.add("temp");
        variables.add("temperr");
        variables.add("tempmean");
        variables.add("salt");
        variables.add("salterr");
        variables.add("saltmean");
        variables.add("dynht");
        variables.add("dynhterr");
        variables.add("dynhtmean");
        NUMVARS = variables.size();
        JGREG = 588829;
        HALFSECOND = 0.5;
    }
}

