/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.plugins.netcdf.NetCDFConverterUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.imagen.ImageN;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class SWANConverter {
    private static final String fileNameIn = "c:\\Work\\data\\rixen\\lscv08\\NRL/SWAN/Ligurian_Sea/2008092500.nc";
    private static final String fileNameOut = "c:/work/data/rixen/converted/converted_2008092500.nc";

    public static void main(String[] args) throws IOException {
        SWANConverter converter = new SWANConverter();
        String fileNameIn = fileNameIn;
        String fileNameOut = fileNameOut;
        converter.run(fileNameIn, fileNameOut);
    }

    private void run(String fileNameIn, String fileNameOut) {
        try {
            File fileIn = new File(fileNameIn);
            NetcdfFile ncFileIn = NetcdfFile.open((String)fileNameIn);
            File fileOut = new File(fileNameOut);
            File outputFile = File.createTempFile(fileIn.getName(), ".tmp");
            NetcdfFileWriteable ncFileOut = NetcdfFileWriteable.createNew((String)outputFile.getAbsolutePath());
            boolean hasZeta = false;
            Dimension timeDim0 = ncFileIn.findDimension("time");
            int nTimes = timeDim0.getLength();
            Dimension latDim0 = ncFileIn.findDimension("latitude");
            int nLat = latDim0.getLength();
            Dimension lonDim0 = ncFileIn.findDimension("longitude");
            int nLon = lonDim0.getLength();
            Variable timeOriginalVar = ncFileIn.findVariable("time");
            Array timeOriginalData = timeOriginalVar.read();
            Index timeOriginalIndex = timeOriginalData.getIndex();
            DataType timeDataType = timeOriginalVar.getDataType();
            Variable lonOriginalVar = ncFileIn.findVariable("longitude");
            DataType lonDataType = lonOriginalVar.getDataType();
            Variable latOriginalVar = ncFileIn.findVariable("latitude");
            DataType latDataType = latOriginalVar.getDataType();
            Array latOriginalData = latOriginalVar.read();
            Array lonOriginalData = lonOriginalVar.read();
            Array levelOriginalData = null;
            int nZeta = 0;
            Array zeta1Data = null;
            Dimension zDim = null;
            DataType zetaDataType = null;
            Variable levelOriginalVar = ncFileIn.findVariable("z");
            if (levelOriginalVar != null) {
                nZeta = levelOriginalVar.getDimension(0).getLength();
                levelOriginalData = levelOriginalVar.read();
                zetaDataType = levelOriginalVar.getDataType();
                hasZeta = true;
            }
            Dimension timeDim = ncFileOut.addDimension("time", nTimes);
            Dimension latDim = ncFileOut.addDimension("lat", nLat);
            Dimension lonDim = ncFileOut.addDimension("lon", nLon);
            if (hasZeta) {
                zDim = ncFileOut.addDimension("height", nZeta);
            }
            NetCDFConverterUtilities.copyGlobalAttributes(ncFileOut, ncFileIn.getGlobalAttributes());
            Variable timeVar = ncFileOut.addVariable("time", timeDataType, new Dimension[]{timeDim});
            NetCDFConverterUtilities.setVariableAttributes(timeOriginalVar, ncFileOut, new String[]{"long_name"});
            ncFileOut.addVariableAttribute("time", "long_name", "time");
            ncFileOut.addVariable("lat", latDataType, new Dimension[]{latDim});
            NetCDFConverterUtilities.setVariableAttributes(latOriginalVar, ncFileOut, "lat");
            ncFileOut.addVariable("lon", lonDataType, new Dimension[]{lonDim});
            NetCDFConverterUtilities.setVariableAttributes(lonOriginalVar, ncFileOut, "lon");
            if (hasZeta) {
                ncFileOut.addVariable("height", zetaDataType, new Dimension[]{zDim});
                NetCDFConverterUtilities.setVariableAttributes(levelOriginalVar, ncFileOut, "height", new String[]{"long_name"});
                ncFileOut.addVariableAttribute("height", "positive", "up");
                ncFileOut.addVariableAttribute("height", "long_name", "height");
            }
            Array lat1Data = NetCDFConverterUtilities.getArray(nLat, latDataType);
            NetCDFConverterUtilities.setData1D(latOriginalData, lat1Data, latDataType, nLat, true);
            Array lon1Data = NetCDFConverterUtilities.getArray(nLon, lonDataType);
            NetCDFConverterUtilities.setData1D(lonOriginalData, lon1Data, lonDataType, nLon, false);
            if (hasZeta) {
                zeta1Data = NetCDFConverterUtilities.getArray(nZeta, zetaDataType);
                NetCDFConverterUtilities.setData1D(levelOriginalData, zeta1Data, zetaDataType, nZeta, false);
            }
            ArrayList<String> variables = new ArrayList<String>(5);
            int numVars = 0;
            List findVariables = ncFileIn.getVariables();
            for (Variable var : findVariables) {
                String varName;
                if (var == null || (varName = var.getName()).equalsIgnoreCase("latitude") || varName.equalsIgnoreCase("longitude") || varName.equalsIgnoreCase("time") || varName.equalsIgnoreCase("z")) continue;
                variables.add(varName);
                List dims = var.getDimensions();
                boolean hasLocalZeta = false;
                for (Dimension dim : dims) {
                    if (!dim.getName().equalsIgnoreCase("z")) continue;
                    hasLocalZeta = true;
                    break;
                }
                if (hasZeta && hasLocalZeta) {
                    ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, zDim, latDim, lonDim});
                } else {
                    ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, latDim, lonDim});
                }
                NetCDFConverterUtilities.setVariableAttributes(var, ncFileOut, new String[]{"missing_value"});
                ++numVars;
            }
            ncFileOut.create();
            ArrayFloat timeData = new ArrayFloat(new int[]{timeDim.getLength()});
            Index timeIndex = timeData.getIndex();
            for (int t = 0; t < timeDim.getLength(); ++t) {
                timeData.setFloat(timeIndex.set(t), timeOriginalData.getFloat(timeOriginalIndex.set(t)));
            }
            ncFileOut.write("time", (Array)timeData);
            timeVar = ncFileOut.findVariable("time");
            timeDim.addCoordinateVariable(timeVar);
            ncFileOut.write("lat", lat1Data);
            ncFileOut.write("lon", lon1Data);
            if (hasZeta) {
                Variable heightVar = ncFileOut.findVariable("height");
                zDim.addCoordinateVariable(heightVar);
                ncFileOut.write("height", zeta1Data);
            }
            for (int i = 0; i < numVars; ++i) {
                String varName = (String)variables.get(i);
                Variable var = ncFileIn.findVariable(varName);
                boolean hasLocalZeta = NetCDFConverterUtilities.hasThisDimension(var, "z");
                Array originalVarArray = var.read();
                DataType varDataType = var.getDataType();
                Array destArray = null;
                int[] dimensions = null;
                dimensions = hasZeta && hasLocalZeta ? new int[]{timeDim.getLength(), zDim.getLength(), latDim.getLength(), lonDim.getLength()} : new int[]{timeDim.getLength(), latDim.getLength(), lonDim.getLength()};
                destArray = NetCDFConverterUtilities.getArray(dimensions, varDataType);
                boolean setZeta = hasZeta && hasLocalZeta;
                int[] loopLengths = setZeta ? new int[]{nTimes, nZeta, nLat, nLon} : new int[]{nTimes, nLat, nLon};
                NetCDFConverterUtilities.writeData(ncFileOut, varName, var, originalVarArray, destArray, false, false, loopLengths, true);
            }
            ncFileOut.close();
            outputFile.renameTo(fileOut);
        }
        catch (Exception e) {
            if (NetCDFConverterUtilities.LOGGER.isLoggable(Level.INFO)) {
                NetCDFConverterUtilities.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            ImageN.getDefaultInstance().getTileCache().flush();
        }
    }
}

