/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.geom.Point2D;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.PropertySource;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.geometry.Position2D;
import org.geotools.util.logging.Logging;

public abstract class AbstractGridCoverage
extends AbstractCoverage
implements GridCoverage {
    private static final long serialVersionUID = 6476934258101450793L;
    public static final Logger LOGGER = Logging.getLogger(AbstractGridCoverage.class);
    private final transient List<GridCoverage> sources;

    protected AbstractGridCoverage(CharSequence name, CoordinateReferenceSystem crs, PropertySource propertySource, Map<?, ?> properties) {
        super(name, crs, propertySource, properties);
        this.sources = null;
    }

    protected AbstractGridCoverage(CharSequence name, CoordinateReferenceSystem crs, GridCoverage[] sources, PropertySource propertySource, Map<?, ?> properties) {
        super(name, crs, propertySource, properties);
        if (sources != null) {
            switch (sources.length) {
                case 0: {
                    this.sources = null;
                    break;
                }
                case 1: {
                    this.sources = Collections.singletonList(sources[0]);
                    break;
                }
                default: {
                    this.sources = Collections.unmodifiableList(Arrays.asList((GridCoverage[])sources.clone()));
                    break;
                }
            }
        } else {
            this.sources = null;
        }
    }

    protected AbstractGridCoverage(CharSequence name, GridCoverage coverage) {
        super(name, (Coverage)coverage);
        this.sources = Collections.singletonList(coverage);
    }

    public List<GridCoverage> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        return Collections.emptyList();
    }

    public boolean isDataEditable() {
        return false;
    }

    public int getNumOverviews() {
        return 0;
    }

    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(this.indexOutOfBounds(index));
    }

    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(this.indexOutOfBounds(index));
    }

    private String indexOutOfBounds(int index) {
        return MessageFormat.format("Illegal argument: \"{0}={1}\".", "index", index);
    }

    protected String formatEvaluateError(Point2D point, boolean outside) {
        return this.formatEvaluateError((Position)new Position2D(point), outside);
    }

    protected String formatEvaluateError(Position point, boolean outside) {
        Locale locale = this.getLocale();
        return MessageFormat.format(outside ? "Coordinate ({0}) is outside coverage." : "Can't evaluate a value for coordinate ({0}).", AbstractGridCoverage.toString(point, locale));
    }

    static String toString(Point2D point, Locale locale) {
        return AbstractGridCoverage.toString((Position)new Position2D(point), locale);
    }

    static String toString(Position point, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        FieldPosition dummy = new FieldPosition(0);
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        int dimension = point.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            format.format(point.getOrdinate(i), buffer, dummy);
        }
        return buffer.toString();
    }
}

