/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class RetypeFeatureReaderTest {
    private static final String UD_KEY = "someKey";
    private static final String UD_VALUE = "someValue";

    @Test
    public void testRetypeUserData() throws Exception {
        SimpleFeatureType featureType = DataUtilities.createType((String)"feature", (String)"id:string,name:String,geometry:Point:srid=4326");
        SimpleFeatureType targetType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)featureType, (String[])new String[]{"id", "geometry"});
        SimpleFeature feature = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"1|foobar|POINT(1 2)");
        feature.getUserData().put(UD_KEY, UD_VALUE);
        ListFeatureCollection features = new ListFeatureCollection(featureType);
        features.add(feature);
        int featuresCount = 0;
        SimpleFeatureReader delegate = DataUtilities.reader((FeatureCollection)features);
        try (ReTypeFeatureReader retyped = new ReTypeFeatureReader((FeatureReader)delegate, targetType);){
            SimpleFeature retypedFeature = retyped.next();
            MatcherAssert.assertThat((Object)retypedFeature, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)retypedFeature.getFeatureType(), (Matcher)CoreMatchers.is((Object)targetType));
            MatcherAssert.assertThat((Object)retypedFeature.getAttribute("name"), (Matcher)CoreMatchers.nullValue());
            MatcherAssert.assertThat(retypedFeature.getUserData().get(UD_KEY), (Matcher)CoreMatchers.is((Object)UD_VALUE));
        }
        MatcherAssert.assertThat((Object)(++featuresCount), (Matcher)CoreMatchers.is((Object)1));
    }
}

