/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ListFeatureCollectionTest {
    private static final double TOL = 1.0E-8;
    private static final CoordinateReferenceSystem DEFAULT_CRS = DefaultEngineeringCRS.CARTESIAN_2D;
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-10.0, 10.0, -5.0, 5.0, DEFAULT_CRS);
    private static final SimpleFeatureType TYPE = ListFeatureCollectionTest.createType();
    private static final GeometryFactory geomFactory = new GeometryFactory();
    private static final Random rand = new Random();
    private SimpleFeatureBuilder fb;
    private ArrayList<SimpleFeature> featureList;
    private ListFeatureCollection featureCollection;

    @Before
    public void setup() {
        this.featureList = new ArrayList();
        this.fb = new SimpleFeatureBuilder(TYPE);
    }

    @Test
    public void size() {
        this.createPointFeatures(WORLD, 42);
        Assert.assertEquals((long)42L, (long)this.featureCollection.size());
    }

    @Test
    public void clear() {
        this.createPointFeatures(WORLD, 42);
        this.featureCollection.clear();
        Assert.assertTrue((boolean)this.featureCollection.isEmpty());
    }

    @Test
    public void getBounds() {
        this.createPointFeaturesAtCorners(WORLD);
        ReferencedEnvelope bounds = this.featureCollection.getBounds();
        Assert.assertTrue((boolean)WORLD.boundsEquals2D((org.opengis.geometry.Envelope)bounds, 1.0E-8));
        Assert.assertEquals((Object)DEFAULT_CRS, (Object)bounds.getCoordinateReferenceSystem());
    }

    @Test
    public void addFeatureIncrementsSize() {
        this.createPointFeatures(WORLD, 1);
        this.featureCollection.add(this.createPointFeature(WORLD.getMinX(), WORLD.getMinY()));
        Assert.assertEquals((long)2L, (long)this.featureCollection.size());
    }

    @Test
    public void addFeatureExpandsBounds() {
        this.createPointFeaturesAtCorners(WORLD);
        double x = WORLD.getMaxX() + WORLD.getWidth();
        double y = WORLD.getMaxY() + WORLD.getHeight();
        this.featureCollection.add(this.createPointFeature(x, y));
        ReferencedEnvelope bounds = this.featureCollection.getBounds();
        Assert.assertEquals((double)x, (double)bounds.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)y, (double)bounds.getMaxY(), (double)1.0E-8);
    }

    @Test
    public void iterator() {
        this.createPointFeaturesAtCorners(WORLD);
        try (SimpleFeatureIterator iter = this.featureCollection.features();){
            Assert.assertNotNull((Object)iter);
            Assert.assertTrue((boolean)iter.hasNext());
            ArrayList<SimpleFeature> copy = new ArrayList<SimpleFeature>(this.featureList);
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                Assert.assertTrue((boolean)copy.remove(f));
            }
            Assert.assertTrue((boolean)copy.isEmpty());
        }
    }

    @Test
    public void removeAndAddFeatureBounds() {
        this.createPointFeatures(WORLD, 3);
        ArrayList<SimpleFeature> copy = new ArrayList<SimpleFeature>(this.featureList);
        SimpleFeature f = (SimpleFeature)copy.get(2);
        this.featureCollection.remove((Object)f);
        ReferencedEnvelope postRemoveFeatureBounds = this.featureCollection.getBounds();
        SimpleFeature newFeature = this.createPointFeature(10.0, 4.0);
        this.featureCollection.add(newFeature);
        ReferencedEnvelope newFeatureBounds = this.featureCollection.getBounds();
        boolean isContained = newFeatureBounds.contains((Envelope)postRemoveFeatureBounds);
        Assert.assertTrue((boolean)isContained);
        Assert.assertNotEquals((Object)newFeatureBounds, (Object)newFeature.getBounds());
    }

    @Test
    public void threeDimensionalFeatureBounds() {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        SimpleFeatureType type = null;
        try {
            type = DataUtilities.createType((String)"testSchema", (String)"name:String,*geom:Geometry");
        }
        catch (SchemaException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        this.featureCollection = new ListFeatureCollection(TYPE, this.featureList);
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature1", gf.createPoint(new Coordinate(10.0, 20.0, 30.0))}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature2", gf.createPoint(new Coordinate(10.0, 10.0, 60.0))}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature2", gf.createPoint(new Coordinate(1.0, 10.0, 6.0))}, null);
        this.featureCollection.add(f1);
        this.featureCollection.add(f2);
        ReferencedEnvelope origBounds = this.featureCollection.getBounds();
        this.featureCollection.remove((Object)f2);
        this.featureCollection.add(f3);
        ReferencedEnvelope postRemoveBounds = this.featureCollection.getBounds();
        Assert.assertNotEquals((Object)origBounds, (Object)postRemoveBounds);
        Assert.assertNotEquals((Object)postRemoveBounds, (Object)f3.getBounds());
        Assert.assertTrue((boolean)postRemoveBounds.contains(f1.getBounds()));
        Assert.assertTrue((boolean)postRemoveBounds.contains(f3.getBounds()));
    }

    private void createPointFeaturesAtCorners(ReferencedEnvelope env) {
        double[] xy = new double[]{env.getMinX(), env.getMinY(), env.getMinX(), env.getMaxY(), env.getMaxX(), env.getMinY(), env.getMaxX(), env.getMaxY()};
        for (int i = 0; i < xy.length; i += 2) {
            Coordinate c = new Coordinate(xy[i], xy[i + 1]);
            this.fb.add((Object)geomFactory.createPoint(c));
            this.fb.add((Object)i);
            this.featureList.add(this.fb.buildFeature(null));
        }
        this.featureCollection = new ListFeatureCollection(TYPE, this.featureList);
    }

    private void createPointFeatures(ReferencedEnvelope env, int count) {
        for (int i = 0; i < count; ++i) {
            double x = WORLD.getMinX() + rand.nextDouble() * WORLD.getWidth();
            double y = WORLD.getMinY() + rand.nextDouble() * WORLD.getHeight();
            this.featureList.add(this.createPointFeature(x, y));
        }
        this.featureCollection = new ListFeatureCollection(TYPE, this.featureList);
    }

    private SimpleFeature createPointFeature(double x, double y) {
        this.fb.add((Object)geomFactory.createPoint(new Coordinate(x, y)));
        this.fb.add((Object)(this.featureList.size() + 1));
        return this.fb.buildFeature(null);
    }

    private static SimpleFeatureType createType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("foo");
        typeBuilder.add("point", Point.class, DEFAULT_CRS);
        typeBuilder.add("id", Integer.class);
        return typeBuilder.buildFeatureType();
    }
}

