/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.geotools.data.simple.DelegateSimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.sort.SortedFeatureIterator;
import org.geotools.data.sort.SortedFeatureReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SortedReaderTest {
    SimpleFeatureReader fr;
    FilterFactory ff;
    SortBy[] peopleAsc;
    SortBy[] peopleDesc;
    SortBy[] fidAsc;
    SortBy[] nullAsc;
    SimpleFeatureType schema;
    DefaultFeatureCollection fc;
    private SortBy[] dateAsc;

    @Before
    public void setup() throws IOException {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.setNamespaceURI("test");
        typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.add("defaultGeom", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.add("PERSONS", Integer.class);
        typeBuilder.add("byte", Byte.class);
        typeBuilder.add("short", Short.class);
        typeBuilder.add("long", Long.class);
        typeBuilder.add("float", Float.class);
        typeBuilder.add("double", Double.class);
        typeBuilder.add("date", java.util.Date.class);
        typeBuilder.add("sql_date", Date.class);
        typeBuilder.add("sql_time", Time.class);
        typeBuilder.add("sql_timestamp", Timestamp.class);
        typeBuilder.add("otherGeom", LineString.class);
        typeBuilder.setDefaultGeometry("defaultGeom");
        this.schema = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.schema);
        GeometryFactory gf = new GeometryFactory();
        this.fc = new DefaultFeatureCollection("test", this.schema);
        double x = -140.0;
        double y = 45.0;
        int features = 500;
        for (int i = 0; i < 500; ++i) {
            Point point = gf.createPoint(new Coordinate(x + (double)i, y + (double)i));
            point.setUserData((Object)DefaultGeographicCRS.WGS84);
            builder.add((Object)point);
            builder.add((Object)i);
            builder.add((Object)((byte)i));
            builder.add((Object)((short)i));
            builder.add((Object)i);
            builder.add((Object)Float.valueOf(i));
            builder.add((Object)i);
            builder.add((Object)new java.util.Date());
            builder.add((Object)new Date(System.currentTimeMillis()));
            builder.add((Object)new Time(System.currentTimeMillis()));
            builder.add((Object)new Timestamp(System.currentTimeMillis()));
            LineString line = gf.createLineString(new Coordinate[]{new Coordinate(x + (double)i, y + (double)i), new Coordinate(x + (double)i + 1.0, y + (double)i + 1.0)});
            line.setUserData((Object)DefaultGeographicCRS.WGS84);
            builder.add((Object)line);
            this.fc.add(builder.buildFeature("" + i));
        }
        builder.add(null);
        builder.add((Object)-1);
        builder.add(null);
        this.fc.add(builder.buildFeature("501"));
        this.fr = new DelegateSimpleFeatureReader(this.schema, this.fc.features());
        this.ff = CommonFactoryFinder.getFilterFactory(null);
        this.peopleAsc = new SortBy[]{this.ff.sort("PERSONS", SortOrder.ASCENDING)};
        this.peopleDesc = new SortBy[]{this.ff.sort("PERSONS", SortOrder.DESCENDING)};
        this.dateAsc = new SortBy[]{this.ff.sort("date", SortOrder.ASCENDING)};
        this.fidAsc = new SortBy[]{SortBy.NATURAL_ORDER};
        this.nullAsc = new SortBy[]{this.ff.sort("null", SortOrder.ASCENDING)};
    }

    @After
    public void tearDown() throws IOException {
        this.fr.close();
    }

    @Test
    public void testCanSort() {
        Assert.assertTrue((boolean)SortedFeatureReader.canSort((SimpleFeatureType)this.schema, (SortBy[])this.peopleAsc));
        Assert.assertTrue((boolean)SortedFeatureReader.canSort((SimpleFeatureType)this.schema, (SortBy[])this.peopleDesc));
        Assert.assertTrue((boolean)SortedFeatureReader.canSort((SimpleFeatureType)this.schema, (SortBy[])this.fidAsc));
        Assert.assertFalse((boolean)SortedFeatureReader.canSort((SimpleFeatureType)this.schema, (SortBy[])this.nullAsc));
    }

    @Test
    public void testMemorySort() throws IOException {
        try (SortedFeatureReader sr = new SortedFeatureReader(this.fr, this.peopleAsc, 1000);){
            this.assertSortedOnPeopleAsc((SimpleFeatureReader)sr);
        }
    }

    @Test
    public void testFileSortDate() throws IOException {
        try (SortedFeatureReader sr = new SortedFeatureReader(this.fr, this.dateAsc, 100);){
            this.assertSortedOnDateAsc((SimpleFeatureReader)sr);
        }
    }

    @Test
    public void testFileSortPeople() throws IOException {
        try (SortedFeatureReader sr = new SortedFeatureReader(this.fr, this.peopleAsc, 5);){
            this.assertSortedOnPeopleAsc((SimpleFeatureReader)sr);
        }
    }

    @Test
    public void testIteratorSortReduce() throws IOException {
        try (SortedFeatureIterator fi = new SortedFeatureIterator(this.fc.features(), this.schema, this.peopleAsc, 1000);){
            this.assertSortedOnPeopleAsc((SimpleFeatureIterator)fi);
        }
    }

    @Test
    public void testSortDescending() throws IOException {
        try (SortedFeatureReader sr = new SortedFeatureReader(this.fr, this.peopleDesc, 1000);){
            double prev = -1.0;
            while (sr.hasNext()) {
                SimpleFeature f = (SimpleFeature)sr.next();
                int curr = (Integer)f.getAttribute("PERSONS");
                if (prev > 0.0) {
                    Assert.assertTrue(((double)curr <= prev ? 1 : 0) != 0);
                }
                prev = curr;
            }
        }
    }

    @Test
    public void testSortNatural() throws IOException {
        try (SortedFeatureReader sr = new SortedFeatureReader(this.fr, this.fidAsc, 1000);){
            String prev = null;
            while (sr.hasNext()) {
                SimpleFeature f = (SimpleFeature)sr.next();
                String id = f.getID();
                if (prev != null) {
                    Assert.assertTrue((id.compareTo(prev) >= 0 ? 1 : 0) != 0);
                }
                prev = id;
            }
        }
    }

    @Test
    public void testSortNaturalPartialLastPage() throws IOException {
        int PRIME = 173;
        try (SortedFeatureReader sr = new SortedFeatureReader(this.fr, this.fidAsc, 173);){
            String prev = null;
            int count = 0;
            while (sr.hasNext()) {
                SimpleFeature f = (SimpleFeature)sr.next();
                String id = f.getID();
                if (prev != null) {
                    Assert.assertTrue((id.compareTo(prev) >= 0 ? 1 : 0) != 0);
                }
                prev = id;
                ++count;
            }
            Assert.assertEquals((long)this.fc.size(), (long)count);
        }
    }

    private void assertSortedOnPeopleAsc(SimpleFeatureReader fr) throws IllegalArgumentException, NoSuchElementException, IOException {
        double prev = -1.0;
        while (fr.hasNext()) {
            SimpleFeature f = (SimpleFeature)fr.next();
            int curr = (Integer)f.getAttribute("PERSONS");
            if (prev > 0.0) {
                Assert.assertTrue(((double)curr >= prev ? 1 : 0) != 0);
            }
            prev = curr;
        }
    }

    private void assertSortedOnDateAsc(SimpleFeatureReader fr) throws IllegalArgumentException, NoSuchElementException, IOException {
        java.util.Date prev = null;
        while (fr.hasNext()) {
            SimpleFeature f = (SimpleFeature)fr.next();
            java.util.Date curr = (java.util.Date)f.getAttribute("date");
            if (prev != null) {
                Assert.assertTrue((prev.compareTo(curr) <= 0 ? 1 : 0) != 0);
            }
            prev = curr;
        }
    }

    private void assertSortedOnPeopleAsc(SimpleFeatureIterator fi) throws IllegalArgumentException, NoSuchElementException, IOException {
        double prev = -1.0;
        while (fi.hasNext()) {
            SimpleFeature f = (SimpleFeature)fi.next();
            int curr = (Integer)f.getAttribute("PERSONS");
            if (prev > 0.0) {
                Assert.assertTrue(((double)curr >= prev ? 1 : 0) != 0);
            }
            prev = curr;
        }
    }
}

