/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.Set;
import org.geotools.data.util.CRSConverterFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSConverterFactoryTest {
    private static final Class<CoordinateReferenceSystem> CRS_CLASS = CoordinateReferenceSystem.class;
    private static final Class<String> STRING_CLASS = String.class;

    @Test
    public void testCRSConverterFactory() {
        Set set = Converters.getConverterFactories(STRING_CLASS, CRS_CLASS);
        Assert.assertNotNull((Object)set);
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertSame(((ConverterFactory)set.iterator().next()).getClass(), CRSConverterFactory.class);
        Set set1 = Converters.getConverterFactories(CRS_CLASS, STRING_CLASS);
        Assert.assertNotNull((Object)set1);
        Assert.assertFalse((boolean)set1.isEmpty());
        Assert.assertEquals((long)set1.size(), (long)1L);
        Assert.assertSame(((ConverterFactory)set1.iterator().next()).getClass(), CRSConverterFactory.class);
        Assert.assertNull((Object)new CRSConverterFactory().createConverter(null, null, null));
        Assert.assertNull((Object)new CRSConverterFactory().createConverter(String.class, null, null));
        Assert.assertNull((Object)new CRSConverterFactory().createConverter(String.class, Double.class, null));
    }

    @Test
    public void testStringToCRS() {
        CoordinateReferenceSystem result = (CoordinateReferenceSystem)Converters.convert((Object)"EPSG:4326", CRS_CLASS);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)CRS_CLASS.isAssignableFrom(result.getClass()));
        String wkt = "GEOGCS[\"WGS 84\", DATUM[\"WGS_1984\", SPHEROID[\"WGS 84\",6378137,298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\",0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\",0.01745329251994328, AUTHORITY[\"EPSG\",\"9122\"]], AUTHORITY[\"EPSG\",\"4326\"]]";
        CoordinateReferenceSystem result1 = (CoordinateReferenceSystem)Converters.convert((Object)wkt, CRS_CLASS);
        Assert.assertNotNull((Object)result1);
        Assert.assertTrue((boolean)CRS_CLASS.isAssignableFrom(result1.getClass()));
        Assert.assertNull((Object)Converters.convert(null, null));
        Assert.assertNull((Object)Converters.convert((Object)wkt.replace("UNIT", "UNITY"), CRS_CLASS));
    }

    @Test
    public void testCRSToString() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        String result = (String)Converters.convert((Object)crs, STRING_CLASS);
        Assert.assertNotNull((Object)result);
        Assert.assertSame(result.getClass(), STRING_CLASS);
    }
}

