/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeatureTypeImplTest {
    @Test
    public void testConsistentIterationOrder() {
        SimpleFeatureType type = this.buildLocationCountType();
        Assert.assertEquals((String)"FeatureType and SimpleFeatureType APIs must return the same descriptors in the same order", new ArrayList(type.getAttributeDescriptors()), new ArrayList(type.getDescriptors()));
    }

    @Test
    public void testOrderSignificantEquals() {
        SimpleFeatureType type1 = this.buildLocationCountType();
        SimpleFeatureType type2 = this.buildCountLocationType();
        Assert.assertNotEquals((String)"Simple feature types with properties in a different order must not be equal", (Object)type1, (Object)type2);
    }

    @Test
    public void testLocationCountEquals() {
        Assert.assertEquals((String)"Identical simple feature types must be equal", (Object)this.buildLocationCountType(), (Object)this.buildLocationCountType());
    }

    @Test
    public void testCountLocationEquals() {
        Assert.assertEquals((String)"Identical simple feature types must be equal", (Object)this.buildCountLocationType(), (Object)this.buildCountLocationType());
    }

    @Test
    public void testGetTypeThreadSafety() {
        SimpleFeatureTypeBuilder builder = this.buildPartialBuilder();
        builder.add("location", Point.class, (CoordinateReferenceSystem)null);
        for (int i = 0; i < 100; ++i) {
            builder.add("" + i, String.class);
        }
        final SimpleFeatureType schema = builder.buildFeatureType();
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals(SimpleFeatureTypeImpl.class, schema.getClass());
        final CountDownLatch latch = new CountDownLatch(8);
        ExecutorService exec = Executors.newFixedThreadPool(8);
        for (int i = 0; i < 8; ++i) {
            class Task
            implements Runnable {
                Task() {
                }

                @Override
                public void run() {
                    schema.getType(99);
                    latch.countDown();
                }
            }
            Task task = new Task();
            exec.submit(task);
        }
        exec.shutdown();
        try {
            exec.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted");
        }
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    private SimpleFeatureType buildLocationCountType() {
        SimpleFeatureTypeBuilder builder = this.buildPartialBuilder();
        builder.add("location", Point.class, (CoordinateReferenceSystem)null);
        builder.add("count", Integer.class);
        return builder.buildFeatureType();
    }

    private SimpleFeatureType buildCountLocationType() {
        SimpleFeatureTypeBuilder builder = this.buildPartialBuilder();
        builder.add("count", Integer.class);
        builder.add("location", Point.class, (CoordinateReferenceSystem)null);
        return builder.buildFeatureType();
    }

    private SimpleFeatureTypeBuilder buildPartialBuilder() {
        String uri = "http://example.org/things";
        FeatureTypeFactoryImpl typeFactory = new FeatureTypeFactoryImpl();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder((FeatureTypeFactory)typeFactory);
        builder.addBinding((AttributeType)typeFactory.createGeometryType((Name)new NameImpl(uri, "description"), String.class, null, false, false, Collections.emptyList(), null, null));
        builder.addBinding((AttributeType)typeFactory.createGeometryType((Name)new NameImpl(uri, "location"), Point.class, null, false, false, Collections.emptyList(), null, null));
        builder.addBinding(typeFactory.createAttributeType((Name)new NameImpl(uri, "count"), Integer.class, false, false, Collections.emptyList(), null, null));
        builder.setName("ThingsType");
        builder.setNamespaceURI(uri);
        builder.add("description", String.class);
        return builder;
    }
}

