/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.EqualAreaListVisitor;
import org.geotools.filter.function.EqualAreaFunction;
import org.geotools.util.NumberRange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

@RunWith(value=Enclosed.class)
public class EqualAreaListVisitorTest {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    public static final Expression PERSONS = FF.property("PERSONS");

    public static ListFeatureCollection getSimplifiedStatesCollection() throws SchemaException, IOException {
        SimpleFeatureType schema = DataUtilities.createType((String)"states", (String)"the_geom:MultiPolygon,STATE_ABBR:String,PERSONS:Double");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(EqualAreaListVisitorTest.class.getResourceAsStream("states.properties")));){
            List featureList = br.lines().map(line -> DataUtilities.createFeature((SimpleFeatureType)schema, (String)line)).collect(Collectors.toList());
            ListFeatureCollection listFeatureCollection = new ListFeatureCollection(schema, featureList);
            return listFeatureCollection;
        }
    }

    public static double getTotalArea(ListFeatureCollection fc, Expression areaFunction) {
        return fc.stream().mapToDouble(f -> (Double)areaFunction.evaluate(f, Double.class)).sum();
    }

    public static NumberRange<Double> getMinMax(ListFeatureCollection fc, Expression attributeExpression) {
        DoubleSummaryStatistics stats = fc.stream().collect(Collectors.summarizingDouble(f -> (Double)attributeExpression.evaluate(f, Double.class)));
        return new NumberRange(Double.class, (Number)stats.getMin(), (Number)stats.getMax());
    }

    @RunWith(value=Parameterized.class)
    public static class ParametricBreaksTest {
        @Parameterized.Parameter
        public int numClasses;
        @Parameterized.Parameter(value=1)
        public double tolerance;

        @Parameterized.Parameters(name="Classes: {0}, Tolerance {1}")
        public static Collection<Object[]> data() {
            return Arrays.asList({2, 0.1}, {3, 0.1}, {4, 0.4}, {5, 0.5}, {6, 0.6}, {7, 0.5});
        }

        @Test
        public void testEqualAreaClassification() throws IOException, SchemaException {
            ListFeatureCollection fc = EqualAreaListVisitorTest.getSimplifiedStatesCollection();
            Function areaFunction = EqualAreaFunction.getCartesianAreaFunction();
            double totalArea = EqualAreaListVisitorTest.getTotalArea(fc, (Expression)areaFunction);
            NumberRange<Double> minMax = EqualAreaListVisitorTest.getMinMax(fc, PERSONS);
            EqualAreaListVisitor visitor = new EqualAreaListVisitor(PERSONS, (Expression)areaFunction, this.numClasses);
            fc.accepts((FeatureVisitor)visitor, null);
            List[] result = (List[])visitor.getResult().getValue();
            List firstBin = result[0];
            MatcherAssert.assertThat((Object)minMax.getMinimum(), (Matcher)Matchers.equalTo((Object)((Double)firstBin.get(0))));
            List lastBin = result[result.length - 1];
            MatcherAssert.assertThat((Object)minMax.getMaximum(), (Matcher)Matchers.equalTo((Object)((Double)lastBin.get(lastBin.size() - 1))));
            Map<PropertyIsBetween, Double> filterMap = Arrays.stream(result).map(list -> FF.between(PERSONS, (Expression)FF.literal(list.get(0)), (Expression)FF.literal(list.get(list.size() - 1)))).collect(Collectors.toMap(k -> k, k -> 0.0));
            for (SimpleFeature feature : fc) {
                boolean found = false;
                for (Map.Entry<PropertyIsBetween, Double> entry : filterMap.entrySet()) {
                    if (!entry.getKey().evaluate((Object)feature)) continue;
                    entry.setValue(entry.getValue() + (Double)areaFunction.evaluate((Object)feature, Double.class));
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
            double averageArea = totalArea / (double)filterMap.size();
            for (Map.Entry<PropertyIsBetween, Double> entry : filterMap.entrySet()) {
                double area = entry.getValue();
                double deviation = Math.abs(area - averageArea) / averageArea;
                MatcherAssert.assertThat((Object)deviation, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(this.tolerance)));
            }
        }
    }

    public static class BasicTests {
        @Test
        public void testEmptyCollection() throws SchemaException, IOException {
            EqualAreaListVisitor visitor = new EqualAreaListVisitor(PERSONS, (Expression)EqualAreaFunction.getCartesianAreaFunction(), 2);
            ListFeatureCollection empty = new ListFeatureCollection(EqualAreaListVisitorTest.getSimplifiedStatesCollection().getSchema());
            empty.accepts((FeatureVisitor)visitor, null);
            Assert.assertEquals((Object)CalcResult.NULL_RESULT, (Object)visitor.getResult());
        }

        @Test
        public void testMoreClassesThanFeatures() throws SchemaException, IOException {
            ListFeatureCollection fc = EqualAreaListVisitorTest.getSimplifiedStatesCollection();
            Function areaFunction = EqualAreaFunction.getCartesianAreaFunction();
            EqualAreaListVisitor visitor = new EqualAreaListVisitor(PERSONS, (Expression)areaFunction, fc.size() * 2);
            fc.accepts((FeatureVisitor)visitor, null);
            List[] result = (List[])visitor.getResult().getValue();
            Assert.assertEquals((long)result.length, (long)43L);
        }
    }
}

