/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.io.IOException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.UniqueCountVisitor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;

public class UniqueCountVisitorTest {
    private static WKTReader wktParser = new WKTReader();
    private static SimpleFeatureType uniqueValuesCountTestType;
    private static FeatureCollection featureCollection;
    static FilterFactory ff;

    @BeforeClass
    public static void setup() throws Exception {
        uniqueValuesCountTestType = DataUtilities.createType((String)"uniqueValuesCount", (String)"id:Integer,aStringValue:String,aDoubleValue:Double,geo:Geometry");
        SimpleFeature[] simpleFeatures = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{1, "A", 50.0, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{2, "B", 10.0, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{3, "C", 20.0, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{4, "D", 30.0, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{5, "E", 60.0, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{6, "E", 10.0, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{7, "D", 500.0, wktParser.read("POINT(-5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{8, "C", 150.0, wktParser.read("POINT(-5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{9, "C", 20.0, wktParser.read("POINT(5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{10, "C", 30.0, wktParser.read("POINT(5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{11, "A", 500.0, wktParser.read("POINT(0 0)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)uniqueValuesCountTestType, (Object[])new Object[]{12, "F", 500.0, wktParser.read("POINT(0 0)")}, null)};
        featureCollection = DataUtilities.collection((SimpleFeature[])simpleFeatures);
    }

    @Test
    public void testUniqueCountVisitor() throws IOException {
        UniqueCountVisitor uniqueCountVisitor = new UniqueCountVisitor("aStringValue");
        featureCollection.accepts((FeatureVisitor)uniqueCountVisitor, null);
        int count = uniqueCountVisitor.getResult().toInt();
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void testUniqueCountVisitor2() throws IOException {
        UniqueCountVisitor uniqueCountVisitor = new UniqueCountVisitor("aDoubleValue");
        featureCollection.accepts((FeatureVisitor)uniqueCountVisitor, null);
        int count = uniqueCountVisitor.getResult().toInt();
        Assert.assertEquals((long)7L, (long)count);
    }

    @Test
    public void testUniqueCountVisitorWithFilter() throws IOException {
        UniqueCountVisitor uniqueCountVisitor = new UniqueCountVisitor("aStringValue");
        Or f = ff.or((Filter)ff.equals((Expression)ff.property("aStringValue"), (Expression)ff.literal((Object)"A")), (Filter)ff.equals((Expression)ff.property("aStringValue"), (Expression)ff.literal((Object)"B")));
        featureCollection.subCollection((Filter)f).accepts((FeatureVisitor)uniqueCountVisitor, null);
        int count = uniqueCountVisitor.getResult().toInt();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testUniqueCountVisitorWithFilter2() throws IOException {
        UniqueCountVisitor uniqueCountVisitor = new UniqueCountVisitor("aDoubleValue");
        Or f = ff.or((Filter)ff.equals((Expression)ff.property("aDoubleValue"), (Expression)ff.literal(500.0)), (Filter)ff.equals((Expression)ff.property("aDoubleValue"), (Expression)ff.literal(20.0)));
        featureCollection.subCollection((Filter)f).accepts((FeatureVisitor)uniqueCountVisitor, null);
        int count = uniqueCountVisitor.getResult().toInt();
        Assert.assertEquals((long)2L, (long)count);
    }

    static {
        ff = CommonFactoryFinder.getFilterFactory2();
    }
}

