/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Within;

public class FilterTest {
    private static final Logger LOGGER = Logging.getLogger(FilterTest.class);
    private static SimpleFeature testFeature = null;
    private static SimpleFeatureType testSchema = null;
    boolean set = false;
    FilterFactory2 fac = CommonFactoryFinder.getFilterFactory2(null);
    private Calendar calDateTime;
    private Calendar calTime;
    private Calendar calDate;

    @Before
    public void setUp() throws SchemaException {
        if (this.set) {
            return;
        }
        this.set = true;
        this.fac = CommonFactoryFinder.getFilterFactory2(null);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.setCRS(null);
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testString2", String.class);
        ftb.add("date", Date.class);
        ftb.add("time", Time.class);
        ftb.add("datetime1", java.util.Date.class);
        ftb.add("datetime2", Timestamp.class);
        ftb.add("nullInt", Integer.class);
        ftb.add("unicodeString", String.class);
        testSchema = ftb.buildFeatureType();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[17];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        attributes[0] = gf.createLineString(coords);
        attributes[1] = Boolean.TRUE;
        attributes[2] = Character.valueOf('t');
        attributes[3] = Byte.valueOf("10");
        attributes[4] = Short.valueOf("101");
        attributes[5] = 1002;
        attributes[6] = 10003L;
        attributes[7] = Float.valueOf(10000.4f);
        attributes[8] = 100000.5;
        attributes[9] = "test string data";
        attributes[10] = "cow $10";
        this.calDate = Calendar.getInstance();
        this.calDate.clear();
        this.calDate.set(2007, 7, 15);
        this.calTime = Calendar.getInstance();
        this.calTime.clear();
        this.calTime.set(11, 12);
        this.calDateTime = Calendar.getInstance();
        this.calDateTime.clear();
        this.calDateTime.set(2007, 7, 15, 12, 0, 0);
        attributes[11] = new Date(this.calDate.getTimeInMillis());
        attributes[12] = new Time(this.calTime.getTimeInMillis());
        attributes[13] = this.calDateTime.getTime();
        attributes[14] = new Timestamp(this.calDateTime.getTimeInMillis());
        attributes[16] = "Bara\u00f1\u00e1in";
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
    }

    @Test
    public void testLikeToSQL() {
        Assert.assertEquals((Object)"BroadWay%", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"BroadWay*", (boolean)true));
        Assert.assertEquals((Object)"broad#ay", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broad#ay", (boolean)true));
        Assert.assertEquals((Object)"broadway", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway", (boolean)true));
        Assert.assertEquals((Object)"broad_ay", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broad.ay", (boolean)true));
        Assert.assertEquals((Object)"broad.ay", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broad!.ay", (boolean)true));
        Assert.assertEquals((Object)"broa''dway", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broa'dway", (boolean)true));
        Assert.assertEquals((Object)"broa''''dway", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broa''dway", (boolean)true));
        Assert.assertEquals((Object)"broa'dway", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broa'dway", (boolean)false));
        Assert.assertEquals((Object)"broa''dway", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broa''dway", (boolean)false));
        Assert.assertEquals((Object)"broadway_", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway.", (boolean)true));
        Assert.assertEquals((Object)"broadway", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway!", (boolean)true));
        Assert.assertEquals((Object)"broadway!", (Object)LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway!!", (boolean)true));
    }

    @Test
    public void testCompare() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testInteger");
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        this.compareStringToIntegerRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareStringToIntegerRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareStringToIntegerRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareStringToIntegerRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareStringToIntegerRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        this.compareIntegerToDoubleRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareIntegerToDoubleRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareIntegerToDoubleRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareIntegerToDoubleRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareIntegerToDoubleRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        testAttribute = new AttributeExpressionImpl(testSchema, "date");
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        testAttribute = new AttributeExpressionImpl(testSchema, "time");
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("test string data");
        Filter filter = this.compare(PropertyIsEqualTo.class, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl("incorrect test string data");
        filter = this.compare(PropertyIsEqualTo.class, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl("zebra");
        filter = this.compare(PropertyIsLessThan.class, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl("blorg");
        filter = this.compare(PropertyIsLessThan.class, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void compareNumberRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl((Object)1001);
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test1);
        testLiteral = new LiteralExpressionImpl((Object)1002);
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test2);
        testLiteral = new LiteralExpressionImpl((Object)1003);
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test3);
    }

    public void compareStringToIntegerRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("1001.0");
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test1);
        testLiteral = new LiteralExpressionImpl("1002.0");
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test2);
        testLiteral = new LiteralExpressionImpl("1003.0");
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test3);
    }

    public void compareIntegerToDoubleRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl((Object)1001.0);
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test1);
        testLiteral = new LiteralExpressionImpl((Object)1002.0);
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test2);
        testLiteral = new LiteralExpressionImpl((Object)1003.0);
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test3);
    }

    public void compareSqlDateRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        Calendar calLocal = Calendar.getInstance();
        calLocal.setTime(this.calDate.getTime());
        calLocal.set(5, this.calDateTime.get(5) - 1);
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl(new Date(calLocal.getTimeInMillis()).toString());
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)test1, (Object)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl(new Date(this.calDate.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)test2, (Object)filter.evaluate((Object)testFeature));
        calLocal.set(5, this.calDateTime.get(5) + 1);
        testLiteral = new LiteralExpressionImpl(new Date(calLocal.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test3);
    }

    Filter compare(Class filterType, Expression a, Expression b) {
        if (filterType == PropertyIsLessThan.class) {
            return this.fac.less(a, b);
        }
        if (filterType == PropertyIsLessThanOrEqualTo.class) {
            return this.fac.lessOrEqual(a, b);
        }
        if (filterType == PropertyIsEqualTo.class) {
            return this.fac.equals(a, b);
        }
        if (filterType == PropertyIsGreaterThanOrEqualTo.class) {
            return this.fac.greaterOrEqual(a, b);
        }
        if (filterType == PropertyIsGreaterThan.class) {
            return this.fac.greater(a, b);
        }
        throw new IllegalArgumentException("Uknown compare filter type " + String.valueOf(filterType));
    }

    public void compareSqlTimeRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        Calendar calLocal = Calendar.getInstance();
        calLocal.setTime(this.calTime.getTime());
        calLocal.set(11, this.calTime.get(11) - 1);
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl(new Time(calLocal.getTimeInMillis()).toString());
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test1);
        testLiteral = new LiteralExpressionImpl(new Time(this.calTime.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test2);
        calLocal.set(11, this.calTime.get(11) + 1);
        testLiteral = new LiteralExpressionImpl(new Time(calLocal.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        Assert.assertEquals((Object)filter.evaluate((Object)testFeature), (Object)test3);
    }

    @Test
    public void testLike() throws IllegalFilterException {
        Pattern compPattern = Pattern.compile("test.*");
        Matcher matcher = compPattern.matcher("test string");
        Assert.assertTrue((boolean)matcher.matches());
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        PropertyIsLike filter = this.fac.like((Expression)testAttribute, "test*", "*", ".", "!");
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "cows*", "*", ".", "!");
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "test*a.", "*", ".", "!");
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "test*dat.", "*", ".", "!");
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testUnicodeLike() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "unicodeString");
        PropertyIsLike filter = this.fac.like((Expression)testAttribute, "Bara\u00f1\u00e1*", "*", ".", "!", false);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "Bara\u00f1\u00e1*", "*", ".", "!", true);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "bara\u00f1\u00e1*", "*", ".", "!", false);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "bara\u00f1\u00e1*", "*", ".", "!", true);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "BARA\u00d1\u00c1*", "*", ".", "!", false);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "BARA\u00d1\u00c1*", "*", ".", "!", true);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testNull() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        PropertyIsNull filter = this.fac.isNull(Expression.NIL);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.isNull((Expression)testAttribute);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testCompareShortCircuit() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsNull nullFilter = this.fac.isNull((Expression)testAttribute);
        Not notNullFilter = this.fac.not((Filter)nullFilter);
        PropertyIsEqualTo compareFilter = this.fac.equals((Expression)testAttribute, (Expression)this.fac.literal(10));
        testFeature.setAttribute("testInteger", null);
        Assert.assertFalse((boolean)compareFilter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)nullFilter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)notNullFilter.evaluate((Object)testFeature));
        And finalFilter = this.fac.and((Filter)notNullFilter, (Filter)compareFilter);
        try {
            Assert.assertFalse((boolean)finalFilter.evaluate((Object)testFeature));
        }
        catch (NullPointerException e) {
            Assert.fail((String)("Short-circuit evaluation was not performed by LogicFilter: " + e.getMessage()));
        }
        finalFilter = this.fac.or((Filter)nullFilter, (Filter)compareFilter);
        try {
            Assert.assertTrue((boolean)finalFilter.evaluate((Object)testFeature));
        }
        catch (NullPointerException e) {
            Assert.fail((String)("Short-circuit evaluation was not performed by LogicFilter: " + e.getMessage()));
        }
    }

    @Test
    public void testBetween() throws IllegalFilterException {
        Literal testLiteralLower = this.fac.literal(1001);
        PropertyName testAttribute = this.fac.property("testInteger");
        Literal testLiteralUpper = this.fac.literal(1003);
        PropertyIsBetween filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteralLower = this.fac.literal(1);
        testLiteralUpper = this.fac.literal(1000);
        filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testBetweenStrings() throws IllegalFilterException {
        LiteralExpressionImpl testLiteralLower = new LiteralExpressionImpl("blorg");
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteralUpper = new LiteralExpressionImpl("tron");
        PropertyIsBetween filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteralLower = new LiteralExpressionImpl("zebra");
        testLiteralUpper = new LiteralExpressionImpl("zikes");
        filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testGeometryEquals() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LineString geom = gf.createLineString(coords);
        LiteralExpressionImpl right = new LiteralExpressionImpl((Object)geom);
        Equals filter = this.fac.equal((Expression)left, (Expression)right);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        filter = this.fac.equal((Expression)left, (Expression)function);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        coords[0] = new Coordinate(0.0, 0.0);
        right = new LiteralExpressionImpl((Object)geom);
        filter = this.fac.equal((Expression)left, (Expression)right);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.equal((Expression)left, (Expression)new LiteralExpressionImpl(null));
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testContains() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Polygon geom = gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]);
        LiteralExpressionImpl expr1 = new LiteralExpressionImpl((Object)geom);
        AttributeExpressionImpl expr2 = new AttributeExpressionImpl(testSchema, "testGeometry");
        Contains filter = this.fac.contains((Expression)expr1, (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        filter = this.fac.contains((Expression)expr1, (Expression)function);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.contains((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        coords = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        geom = gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]);
        expr1 = new LiteralExpressionImpl((Object)geom);
        filter = this.fac.contains((Expression)expr1, (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.contains((Expression)new LiteralExpressionImpl(null), (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testWithin() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Polygon geom = gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]);
        LiteralExpressionImpl expr2 = new LiteralExpressionImpl((Object)geom);
        AttributeExpressionImpl expr1 = new AttributeExpressionImpl(testSchema, "testGeometry");
        Within filter = this.fac.within((Expression)expr1, (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        filter = this.fac.within((Expression)expr1, (Expression)function);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.within((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        coords = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        expr2 = new LiteralExpressionImpl((Object)gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]));
        filter = this.fac.within((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        expr2 = new LiteralExpressionImpl(null);
        filter = this.fac.within((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testDisjoint() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(3.0, 0.0), new Coordinate(6.0, 0.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        AttributeExpressionImpl expr1 = new AttributeExpressionImpl(testSchema, "testGeometry");
        LineString geom = gf.createLineString(coords);
        LiteralExpressionImpl expr2 = new LiteralExpressionImpl((Object)geom);
        Disjoint disjoint = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)disjoint.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        disjoint = this.fac.disjoint((Expression)expr1, (Expression)function);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)disjoint.evaluate((Object)testFeature));
        disjoint = this.fac.disjoint((Expression)expr2, (Expression)expr1);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)disjoint.evaluate((Object)testFeature));
        coords[0] = new Coordinate(1.0, 2.0);
        coords[1] = new Coordinate(3.0, 0.0);
        coords[2] = new Coordinate(6.0, 0.0);
        geom = gf.createLineString(coords);
        expr2 = new LiteralExpressionImpl((Object)geom);
        disjoint = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)disjoint.evaluate((Object)testFeature));
        expr2 = new LiteralExpressionImpl(null);
        disjoint = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)disjoint.evaluate((Object)testFeature));
    }

    @Test
    public void testIntersects() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 5.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 1.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        AttributeExpressionImpl expr1 = new AttributeExpressionImpl(testSchema, "testGeometry");
        LineString geom = gf.createLineString(coords);
        LiteralExpressionImpl expr2 = new LiteralExpressionImpl((Object)geom);
        Intersects intersects = this.fac.intersects((Expression)expr1, (Expression)expr2);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        intersects = this.fac.intersects((Expression)expr2, (Expression)expr1);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        intersects = this.fac.intersects((Expression)expr1, (Expression)function);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        coords[0] = new Coordinate(0.0, 0.0);
        coords[1] = new Coordinate(3.0, 0.0);
        coords[2] = new Coordinate(6.0, 0.0);
        expr2 = new LiteralExpressionImpl((Object)gf.createLineString(coords));
        intersects = this.fac.intersects((Expression)expr1, (Expression)expr2);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)intersects.evaluate((Object)testFeature));
        expr2 = new LiteralExpressionImpl(null);
        intersects = this.fac.intersects((Expression)expr1, (Expression)expr2);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)intersects.evaluate((Object)testFeature));
    }

    @Test
    public void testBBOX() throws IllegalFilterException {
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        BBOX bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 10.0, 10.0, null);
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)bbox.evaluate((Object)testFeature));
        bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 1.0, 1.0, null);
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)bbox.evaluate((Object)testFeature));
        bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 10.0, 10.0, "EPSG:4326");
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)bbox.evaluate((Object)testFeature));
        bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 10.0, 10.0, "");
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)bbox.evaluate((Object)testFeature));
    }

    @Test
    public void testDWithin() throws Exception {
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(10.0, 10.0), new Coordinate(15.0, 10.0), new Coordinate(15.0, 15.0), new Coordinate(10.0, 15.0), new Coordinate(10.0, 10.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LiteralExpressionImpl right = new LiteralExpressionImpl((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        DWithin filter = this.fac.dwithin((Expression)left, (Expression)right, 20.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.dwithin((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        right = new LiteralExpressionImpl(null);
        filter = this.fac.dwithin((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testBeyond() throws Exception {
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(10.0, 10.0), new Coordinate(15.0, 10.0), new Coordinate(15.0, 15.0), new Coordinate(10.0, 15.0), new Coordinate(10.0, 10.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LiteralExpressionImpl right = new LiteralExpressionImpl((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        Beyond filter = this.fac.beyond((Expression)left, (Expression)right, 20.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.beyond((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        coords2[0] = new Coordinate(20.0, 20.0);
        coords2[1] = new Coordinate(21.0, 20.0);
        coords2[2] = new Coordinate(21.0, 21.0);
        coords2[3] = new Coordinate(20.0, 21.0);
        coords2[4] = new Coordinate(20.0, 20.0);
        right = this.fac.literal((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        filter = this.fac.beyond((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        right = new LiteralExpressionImpl(null);
        filter = this.fac.beyond((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testFid() {
        Id ff = this.fac.id(new HashSet());
        Assert.assertFalse((boolean)ff.evaluate((Object)testFeature));
        ff = this.fac.id(Collections.singleton(this.fac.featureId(testFeature.getID())));
        Assert.assertTrue((boolean)ff.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)ff.evaluate(null));
        Assert.assertFalse((boolean)ff.evaluate(new Object()));
    }

    @Test
    public void testOrFilter() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("test string data");
        PropertyIsEqualTo filterTrue = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        testLiteral = new LiteralExpressionImpl("incorrect test string data");
        PropertyIsEqualTo filterFalse = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        Or filter = this.fac.or((Filter)filterFalse, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.or((Filter)filterTrue, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.or((Filter)filterFalse, (Filter)filterFalse);
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    @Test
    public void testAndFilter() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("test string data");
        PropertyIsEqualTo filterTrue = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        testLiteral = new LiteralExpressionImpl("incorrect test string data");
        PropertyIsEqualTo filterFalse = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        And filter = this.fac.and((Filter)filterFalse, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.and((Filter)filterTrue, (Filter)filterFalse);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.and((Filter)filterTrue, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        Assert.assertTrue((boolean)filter.evaluate((Object)testFeature));
        Assert.assertFalse((boolean)this.fac.not((Filter)filter).evaluate((Object)testFeature));
    }

    @Test
    public void testLiteralExpression() {
        LiteralExpressionImpl literal = new LiteralExpressionImpl(1.0);
        Assert.assertEquals((long)101L, (long)Filters.getExpressionType((Expression)literal));
        Assert.assertEquals((Object)1.0, (Object)literal.evaluate(null));
        GeometryFactory gf = new GeometryFactory();
        literal = new LiteralExpressionImpl((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        Assert.assertEquals((long)104L, (long)Filters.getExpressionType((Expression)literal));
        Geometry value = (Geometry)literal.evaluate(null);
        Assert.assertTrue((boolean)gf.createPoint(new Coordinate(0.0, 0.0)).equalsExact(value));
        literal = new LiteralExpressionImpl(1);
        Assert.assertEquals((long)102L, (long)Filters.getExpressionType((Expression)literal));
        Assert.assertEquals((Object)1, (Object)literal.evaluate(null));
        literal = new LiteralExpressionImpl(1L);
        Assert.assertEquals((long)99L, (long)Filters.getExpressionType((Expression)literal));
        Assert.assertEquals((Object)1L, (Object)literal.evaluate(null));
        literal = new LiteralExpressionImpl("string value");
        Assert.assertEquals((long)103L, (long)Filters.getExpressionType((Expression)literal));
        Assert.assertEquals((Object)"string value", (Object)literal.evaluate(null));
        literal = new LiteralExpressionImpl((Object)new java.util.Date(0L));
        Assert.assertEquals((long)115L, (long)Filters.getExpressionType((Expression)literal));
        Assert.assertEquals((Object)new java.util.Date(0L), (Object)literal.evaluate(null));
        literal = new LiteralExpressionImpl(null);
        Assert.assertEquals((long)115L, (long)Filters.getExpressionType((Expression)literal));
        Assert.assertNull((Object)literal.evaluate(null));
    }

    @Test
    public void testEvaluateNonFeatureObject() {
        MockDataObject object = new MockDataObject();
        object.intVal = 5;
        object.stringVal = "cinco";
        PropertyIsGreaterThan f = this.fac.greater((Expression)this.fac.property("intVal"), (Expression)this.fac.literal(3));
        Assert.assertTrue((boolean)f.evaluate((Object)object));
        And f2 = this.fac.and((Filter)f, (Filter)this.fac.equals((Expression)this.fac.property("stringVal"), (Expression)this.fac.literal((Object)"cinco")));
        Assert.assertTrue((boolean)f2.evaluate((Object)object));
        And f3 = this.fac.and((Filter)f, (Filter)this.fac.equals((Expression)this.fac.property("stringVal"), (Expression)this.fac.literal((Object)"seis")));
        Assert.assertFalse((boolean)f3.evaluate((Object)object));
        Not f4 = this.fac.not((Filter)this.fac.and((Filter)f, (Filter)this.fac.equals((Expression)this.fac.property("stringVal"), (Expression)this.fac.literal((Object)"cinco"))));
        Assert.assertFalse((boolean)f4.evaluate((Object)object));
    }

    @Test
    public void testSafeConversions() {
        Literal d = this.fac.literal(1.1);
        Literal i = this.fac.literal(1);
        PropertyIsGreaterThan f1 = this.fac.greater((Expression)d, (Expression)i);
        Assert.assertTrue((boolean)f1.evaluate(null));
        PropertyIsLessThan f2 = this.fac.less((Expression)i, (Expression)d);
        Assert.assertTrue((boolean)f2.evaluate(null));
    }

    @Test
    public void testFilterEquality() {
        PropertyIsLessThan f1 = this.fac.less((Expression)this.fac.property("ATR"), (Expression)this.fac.literal((Object)"32"));
        PropertyIsNotEqualTo f2 = this.fac.notEqual((Expression)this.fac.property("ATR2"), (Expression)this.fac.literal((Object)"1"));
        Assert.assertEquals((Object)f1, (Object)f1);
        Assert.assertNotEquals((Object)f1, (Object)f2);
        Assert.assertNotEquals((Object)f2, (Object)f1);
        PropertyIsNotEqualTo f4 = this.fac.notEqual((Expression)this.fac.property("BBB"), (Expression)this.fac.literal((Object)"2"));
        Assert.assertNotEquals((Object)f2, (Object)f4);
        Assert.assertNotEquals((Object)f4, (Object)f2);
        PropertyIsLessThan f3 = this.fac.less((Expression)this.fac.property("ATR"), (Expression)this.fac.literal((Object)"40"));
        Assert.assertNotEquals((Object)f1, (Object)f3);
        Assert.assertNotEquals((Object)f3, (Object)f1);
        Literal l32 = this.fac.literal((Object)"32");
        Literal l40 = this.fac.literal((Object)"40");
        Assert.assertNotEquals((Object)l32, (Object)l40);
        Assert.assertNotEquals((Object)l40, (Object)l32);
    }

    @Test
    public void testNullBetween() {
        PropertyIsBetween f = this.fac.between((Expression)this.fac.property("nullInt"), (Expression)this.fac.literal(10), (Expression)this.fac.literal(20));
        Assert.assertFalse((boolean)f.evaluate((Object)testFeature));
    }

    @Test
    public void testBoundedBy() {
        Polygon box = JTS.toGeometry((Envelope)new Envelope(0.0, 10.0, 0.0, 10.0));
        Intersects intersects = this.fac.intersects((Expression)this.fac.function("boundedBy", new Expression[0]), (Expression)this.fac.literal((Object)box));
        Assert.assertTrue((boolean)intersects.evaluate((Object)testFeature));
    }

    private final class GeometryFunction
    implements Function {
        final Geometry ls;

        public GeometryFunction(Geometry geom) throws Exception {
            this.ls = geom;
        }

        public String getName() {
            return "function";
        }

        public FunctionName getFunctionName() {
            return new FunctionNameImpl(this.getName(), 0);
        }

        public List<Expression> getParameters() {
            return Collections.emptyList();
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return visitor.visit((Function)this, extraData);
        }

        public Object evaluate(Object object) {
            return this.ls;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            return context.cast(this.ls);
        }

        public Literal getFallbackValue() {
            return null;
        }
    }

    public static class MockPropertyAccessorFactory
    implements PropertyAccessorFactory {
        public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
            if (!MockDataObject.class.equals((Object)type)) {
                return null;
            }
            return new PropertyAccessor(){

                public boolean canHandle(Object object, String xpath, Class target) {
                    return object instanceof MockDataObject;
                }

                public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
                    if (object == null) {
                        return null;
                    }
                    try {
                        Object value;
                        Field field = MockDataObject.class.getField(xpath);
                        Object cast = value = field.get(object);
                        return (T)cast;
                    }
                    catch (Exception e) {
                        throw (IllegalArgumentException)new IllegalArgumentException("Illegal property name: " + xpath).initCause(e);
                    }
                }

                public void set(Object object, String xpath, Object value, Class target) throws IllegalArgumentException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class MockDataObject {
        public int intVal;
        public String stringVal;

        public MockDataObject() {
            this(0, null);
        }

        public MockDataObject(int intVal, String stringVal) {
            this.intVal = intVal;
            this.stringVal = stringVal;
        }
    }
}

