/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.GeometryTransformationVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;

public class GeometryFilterVisitorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testSimpleBuffer() {
        Function geomTx = this.ff.function("buffer", new Expression[]{this.ff.property("the_geom"), this.ff.literal(2)});
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 2.0, 0.0, 2.0, null);
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = (ReferencedEnvelope)geomTx.accept((ExpressionVisitor)visitor, (Object)re);
        ReferencedEnvelope expected = new ReferencedEnvelope(-2.0, 4.0, -2.0, 4.0, null);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testChainBuffer() {
        Function innerBuffer = this.ff.function("buffer", new Expression[]{this.ff.property("the_geom"), this.ff.literal(3)});
        Function geomTx = this.ff.function("buffer", new Expression[]{innerBuffer, this.ff.literal(2)});
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 2.0, 0.0, 2.0, null);
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = (ReferencedEnvelope)geomTx.accept((ExpressionVisitor)visitor, (Object)re);
        ReferencedEnvelope expected = new ReferencedEnvelope(-5.0, 7.0, -5.0, 7.0, null);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testChainIntersection() {
        Function innerBuffer1 = this.ff.function("buffer", new Expression[]{this.ff.property("the_geom"), this.ff.literal(3)});
        Function innerBuffer2 = this.ff.function("buffer", new Expression[]{this.ff.property("other_geom"), this.ff.literal(2)});
        Function geomTx = this.ff.function("intersection", new Expression[]{innerBuffer1, innerBuffer2});
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 2.0, 0.0, 2.0, null);
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = (ReferencedEnvelope)geomTx.accept((ExpressionVisitor)visitor, (Object)re);
        ReferencedEnvelope expected = new ReferencedEnvelope(-3.0, 5.0, -3.0, 5.0, null);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

