/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.math.BigDecimal;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class IsEqualsToImplTest {
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testOperandsSameType() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal(1);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertTrue((boolean)equal.evaluate(null));
    }

    @Test
    public void testOperandsShort() {
        Literal literalShort42 = this.filterFactory.literal((short)42);
        Literal literalString42 = this.filterFactory.literal((Object)"42");
        Literal literalDouble42 = this.filterFactory.literal(42.0);
        Literal literalLong42 = this.filterFactory.literal(42L);
        Literal literalFloat42 = this.filterFactory.literal(42.0f);
        Literal literalBig42 = this.filterFactory.literal((Object)new BigDecimal(42));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalShort42).evaluate(null));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalString42).evaluate(null));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalDouble42).evaluate(null));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalLong42).evaluate(null));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalFloat42).evaluate(null));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalBig42).evaluate(null));
        Assert.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalDouble42).evaluate(null));
    }

    @Test
    public void testOperandsIntString() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"1");
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertTrue((boolean)equal.evaluate(null));
    }

    @Test
    public void testOperandsIntFloatString() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"1.2");
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertFalse((boolean)equal.evaluate(null));
    }

    @Test
    public void testOperandsLongInt() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal(1L);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertTrue((boolean)equal.evaluate(null));
    }

    @Test
    public void testOperandsFloatInt() {
        Literal e1 = this.filterFactory.literal(1.0f);
        Literal e2 = this.filterFactory.literal(1);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertTrue((boolean)equal.evaluate(null));
    }

    @Test
    public void testOperandsDoubleLong() {
        Literal e1 = this.filterFactory.literal(1.0);
        Literal e2 = this.filterFactory.literal(1L);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertTrue((boolean)equal.evaluate(null));
    }

    @Test
    public void testOperandsDoubleLongOutOfRange() {
        Literal e1 = this.filterFactory.literal(9.223372036854786E18);
        Literal e2 = this.filterFactory.literal(Long.MAX_VALUE);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        Assert.assertFalse((boolean)equal.evaluate(null));
    }

    @Test
    public void testCaseSensitivity() {
        Literal e1 = this.filterFactory.literal((Object)"foo");
        Literal e2 = this.filterFactory.literal((Object)"FoO");
        PropertyIsEqualTo caseSensitive = this.filterFactory.equal((Expression)e1, (Expression)e2, true);
        Assert.assertFalse((boolean)caseSensitive.evaluate(null));
        PropertyIsEqualTo caseInsensitive = this.filterFactory.equal((Expression)e1, (Expression)e2, false);
        Assert.assertTrue((boolean)caseInsensitive.evaluate(null));
    }

    @Test
    public void testLiteralConversion() {
        Literal e1 = this.filterFactory.literal((Object)"true");
        Literal e2 = this.filterFactory.literal((Object)Boolean.TRUE);
        PropertyIsEqualTo caseSensitive = this.filterFactory.equal((Expression)e1, (Expression)e2, true);
        Assert.assertTrue((boolean)caseSensitive.evaluate(null));
        PropertyIsEqualTo caseInsensitive = this.filterFactory.equal((Expression)e1, (Expression)e2, false);
        Assert.assertTrue((boolean)caseInsensitive.evaluate(null));
    }
}

