/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Calendar;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class DateFunctionTest {
    @Test
    public void testDateParse() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Literal pattern = ff.literal((Object)"yyyy");
        Literal year = ff.literal((Object)"1975");
        Function f = ff.function("dateParse", new Expression[]{pattern, year});
        Calendar cal = (Calendar)f.evaluate(null, Calendar.class);
        Assert.assertEquals((long)1975L, (long)cal.get(1));
    }

    @Test
    public void testDateEncode() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Literal pattern = ff.literal((Object)"yyyy");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 2000);
        Literal date = ff.literal((Object)cal.getTime());
        Function f = ff.function("dateFormat", new Expression[]{pattern, date});
        String year = (String)f.evaluate(null, String.class);
        Assert.assertEquals((Object)"2000", (Object)year);
    }
}

