/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.geotools.data.DataTestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.function.FilterFunction_property;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FilterFunctionPropertyTest
extends DataTestCase {
    private static final int LOOPS = 5000;
    static FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    @After
    public void teardown() {
        EnvFunction.clearLocalValues();
    }

    @Test
    public void testLocateFunction() {
        Function f = new FunctionFinder(null).findFunction("property");
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)(f instanceof FilterFunction_property));
    }

    @Test
    public void testEvaluateProperty() {
        Function f = FF.function("property", new Expression[]{FF.literal((Object)"name")});
        String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        Assert.assertEquals((Object)"r1", (Object)result);
    }

    @Test
    public void testEvaluateAndConvert() {
        Function f = FF.function("property", new Expression[]{FF.literal((Object)"geom")});
        String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        Assert.assertEquals((Object)"LINESTRING (1 1, 2 2, 4 2, 5 1)", (Object)result);
    }

    @Test
    public void testEvaluateAlternate() {
        Function f = FF.function("property", new Expression[]{FF.function("env", new Expression[]{FF.literal((Object)"pname")})});
        EnvFunction.setLocalValue((String)"pname", (Object)"name");
        String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        Assert.assertEquals((Object)"r1", (Object)result);
        EnvFunction.setLocalValue((String)"pname", (Object)"geom");
        result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        Assert.assertEquals((Object)"LINESTRING (1 1, 2 2, 4 2, 5 1)", (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvaluateMultithreaded() throws Exception {
        Function f = FF.function("property", new Expression[]{FF.function("env", new Expression[]{FF.literal((Object)"pname")})});
        Callable<Void> nameEvaluator = () -> {
            try {
                EnvFunction.setLocalValue((String)"pname", (Object)"name");
                for (int i = 0; i < 1000; ++i) {
                    String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
                    Assert.assertEquals((Object)"r1", (Object)result);
                }
            }
            finally {
                EnvFunction.clearLocalValues();
            }
            return null;
        };
        Callable<Void> geomEvaluator = () -> {
            try {
                EnvFunction.setLocalValue((String)"pname", (Object)"geom");
                for (int i = 0; i < 5000; ++i) {
                    String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
                    Assert.assertEquals((Object)"LINESTRING (1 1, 2 2, 4 2, 5 1)", (Object)result);
                }
            }
            finally {
                EnvFunction.clearLocalValues();
            }
            return null;
        };
        ExecutorService es = Executors.newCachedThreadPool();
        try {
            Future<Void> fname = es.submit(nameEvaluator);
            Future<Void> fgeom = es.submit(geomEvaluator);
            fname.get();
            fgeom.get();
        }
        finally {
            es.shutdown();
        }
    }
}

