/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.factory.FactoryIteratorProvider;
import org.geotools.util.factory.GeoTools;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionFactoryTest {
    static FactoryIteratorProvider ffIteratorProvider;

    @BeforeClass
    public static void setUpClass() {
        ffIteratorProvider = new FactoryIteratorProvider(){

            public <T> Iterator<T> iterator(Class<T> category) {
                if (FunctionFactory.class == category) {
                    ArrayList<1> l = new ArrayList<1>();
                    l.add(new FunctionFactory(){

                        public List<FunctionName> getFunctionNames() {
                            return Arrays.asList(new FunctionNameImpl("foo", new String[]{"bar", "baz"}));
                        }

                        public Function function(String name, List<Expression> args, Literal fallback) {
                            return this.function((Name)new NameImpl(name), args, fallback);
                        }

                        public Function function(Name name, List<Expression> args, Literal fallback) {
                            if ("foo".equals(name.getLocalPart())) {
                                return new FunctionImpl(){

                                    public <T> T evaluate(Object object, Class<T> context) {
                                        return context.cast("theResult");
                                    }
                                };
                            }
                            return null;
                        }
                    });
                    Iterator cast = l.iterator();
                    return cast;
                }
                return null;
            }
        };
        GeoTools.addFactoryIteratorProvider((FactoryIteratorProvider)ffIteratorProvider);
        CommonFactoryFinder.reset();
    }

    @AfterClass
    public static void tearDownClass() {
        GeoTools.removeFactoryIteratorProvider((FactoryIteratorProvider)ffIteratorProvider);
    }

    @Test
    public void testLookup() {
        Set factories = CommonFactoryFinder.getFunctionFactories(null);
        FunctionFactory factory = null;
        block0: for (FunctionFactory ff : factories) {
            for (FunctionName fn : ff.getFunctionNames()) {
                if (!"foo".equals(fn.getName())) continue;
                factory = ff;
                continue block0;
            }
        }
        Assert.assertNotNull(factory);
        Function f = factory.function("foo", null, null);
        Assert.assertNotNull((Object)f);
    }

    @Test
    public void testThreadedFunctionLookup() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        ExecutorService es = Executors.newCachedThreadPool();
        ArrayList<Future<Exception>> tests = new ArrayList<Future<Exception>>();
        for (int i = 0; i < 100; ++i) {
            Future<Exception> future = es.submit(() -> {
                try {
                    ff.function("Length", new Expression[]{ff.property(".")});
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            });
            tests.add(future);
        }
        for (Future future : tests) {
            Exception e = (Exception)future.get();
            if (e != null) {
                Logger.getGlobal().log(Level.INFO, "", e);
            }
            Assert.assertNull((String)"No exception was expected", (Object)e);
        }
        es.shutdown();
    }
}

