/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class JsonPointerFunctionTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testSimplePointers() {
        String json = "{\n    \"foo\" : [\"bar\", \"baz\"],\n    \"nested\" : {\"a\" : 1, \"b\": 2},\n    \"pi\" : 3.1416,\n    \"v\" : 1234,\n    \"t\" : true,\n    \"f\" : false\n}";
        Assert.assertEquals((Object)"bar", (Object)this.pointer(json, "/foo/0").evaluate(null));
        Assert.assertEquals((Object)"baz", (Object)this.pointer(json, "/foo/1").evaluate(null));
        Assert.assertEquals((Object)1, (Object)this.pointer(json, "/nested/a").evaluate(null));
        Assert.assertEquals((Object)2, (Object)this.pointer(json, "/nested/b").evaluate(null));
        Assert.assertEquals((double)3.1416, (double)((Float)this.pointer(json, "/pi").evaluate(null)).floatValue(), (double)0.001);
        Assert.assertEquals((Object)1234, (Object)this.pointer(json, "/v").evaluate(null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.pointer(json, "/t").evaluate(null));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.pointer(json, "/f").evaluate(null));
        Assert.assertNull((Object)this.pointer(json, "/foobar").evaluate(null));
        Assert.assertNull((Object)this.pointer(json, "/").evaluate(null));
    }

    @Test
    public void testNestArrayObjects() {
        String json = "{\n  \"prop\": {\n    \"a\": [\n      {\n        \"b\": 10\n      },\n      {\n        \"b\": 20\n      }\n    ]\n  }\n}";
        Assert.assertEquals((Object)10, (Object)this.pointer(json, "/prop/a/0/b").evaluate(null));
        Assert.assertEquals((Object)20, (Object)this.pointer(json, "/prop/a/1/b").evaluate(null));
    }

    @Test
    public void testExtractArray() {
        String json = "{\"foo\" : [\"bar\", \"baz\"]}";
        Assert.assertEquals((Object)"[\"bar\",\"baz\"]", (Object)this.pointer(json, "/foo").evaluate(null));
    }

    @Test
    public void testExtractObject() {
        String json = "{\"nested\" : {\"a\" : 1, \"b\": 2}}";
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2}", (Object)this.pointer(json, "/nested").evaluate(null));
    }

    @Test
    public void testExtractComplex() {
        String json = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"File\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        Assert.assertEquals((Object)"{\"menuitem\":[{\"value\":\"New\",\"onclick\":\"CreateNewDoc()\"},{\"value\":\"Open\",\"onclick\":\"OpenDoc()\"},{\"value\":\"Close\",\"onclick\":\"CloseDoc()\"}]}", (Object)this.pointer(json, "/menu/popup").evaluate(null));
        Assert.assertEquals((Object)"[{\"value\":\"New\",\"onclick\":\"CreateNewDoc()\"},{\"value\":\"Open\",\"onclick\":\"OpenDoc()\"},{\"value\":\"Close\",\"onclick\":\"CloseDoc()\"}]", (Object)this.pointer(json, "/menu/popup/menuitem").evaluate(null));
    }

    public Function pointer(String json, String pointer) {
        return FF.function("jsonPointer", new Expression[]{FF.literal((Object)json), FF.literal((Object)pointer)});
    }
}

